/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebRequest;
import lombok.Generated;

public class WebsocketResponseInterceptor
implements DispatchInterceptor {
    @Override
    public Message interceptDispatch(Message message, MessageType messageType) {
        HttpRequestMethod requestMethod;
        DeserializingMessage currentMessage = DeserializingMessage.getCurrent();
        if (currentMessage != null && currentMessage.getMessageType() == MessageType.WEBREQUEST && (requestMethod = WebRequest.getMethod(currentMessage.getMetadata())) != null && requestMethod.isWebsocket()) {
            if (requestMethod == HttpRequestMethod.WS_HANDSHAKE) {
                message = message.addMetadata("clientId", FluxCapacitor.getOptionally().map(fc -> fc.client().id()).orElse(null), "trackerId", Tracker.current().map(Tracker::getTrackerId).orElse(null));
            } else {
                return message.withMetadata(message.getMetadata().with((Object)"sessionId", (Object)currentMessage.getMetadata().get("sessionId")).addIfAbsent("function", message.getPayload() == null ? "ack" : "message"));
            }
        }
        return message;
    }

    @Generated
    public WebsocketResponseInterceptor() {
    }
}

