/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Reified;
import io.jooby.ValueNode;
import io.jooby.exception.MissingValueException;
import io.jooby.internal.ByteArrayBody;
import io.jooby.internal.FileBody;
import io.jooby.internal.InputStreamBody;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface Body
extends ValueNode {
    @NonNull
    default public String value(@NonNull Charset charset) {
        byte[] bytes = this.bytes();
        if (bytes.length == 0) {
            throw new MissingValueException("body");
        }
        return new String(bytes, charset);
    }

    @NonNull
    public byte[] bytes();

    public boolean isInMemory();

    public long getSize();

    @NonNull
    public ReadableByteChannel channel();

    @NonNull
    public InputStream stream();

    @Override
    @NonNull
    default public <T> List<T> toList(@NonNull Class<T> type) {
        return (List)this.to(Reified.list(type).getType());
    }

    @Override
    @NonNull
    default public List<String> toList() {
        return Collections.singletonList(this.value());
    }

    @Override
    @NonNull
    default public Set<String> toSet() {
        return Collections.singleton(this.value());
    }

    @Override
    @NonNull
    default public <T> T to(@NonNull Class<T> type) {
        return this.to((Type)type);
    }

    @Override
    @Nullable
    default public <T> T toNullable(@NonNull Class<T> type) {
        return this.toNullable((Type)type);
    }

    @NonNull
    public <T> T to(@NonNull Type var1);

    @Nullable
    public <T> T toNullable(@NonNull Type var1);

    @NonNull
    public static Body empty(@NonNull Context ctx) {
        return ByteArrayBody.empty(ctx);
    }

    @NonNull
    public static Body of(@NonNull Context ctx, @NonNull InputStream stream, long size) {
        return new InputStreamBody(ctx, stream, size);
    }

    @NonNull
    public static Body of(@NonNull Context ctx, @NonNull byte[] bytes) {
        return new ByteArrayBody(ctx, bytes);
    }

    @NonNull
    public static Body of(@NonNull Context ctx, @NonNull Path file) {
        return new FileBody(ctx, file);
    }
}

