/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.StatusCode;
import io.jooby.internal.NoByteRange;
import io.jooby.internal.NotSatisfiableByteRange;
import io.jooby.internal.SingleByteRange;
import java.io.IOException;
import java.io.InputStream;

public interface ByteRange {
    public static final String BYTES_RANGE = "bytes=";

    @NonNull
    public static ByteRange parse(@Nullable String value, long contentLength) {
        if (contentLength <= 0L || value == null) {
            return new NoByteRange(contentLength);
        }
        if (!value.startsWith(BYTES_RANGE)) {
            return new NotSatisfiableByteRange(value, contentLength);
        }
        try {
            char ch;
            int i;
            long[] range = new long[]{-1L, -1L};
            int r = 0;
            int len = value.length();
            int offset = i = BYTES_RANGE.length();
            while (i < len && (ch = value.charAt(i)) != ',') {
                if (ch == '-') {
                    if (offset < i) {
                        range[r] = Long.parseLong(value.substring(offset, i).trim());
                    }
                    offset = i + 1;
                    ++r;
                }
                ++i;
            }
            if (offset < i) {
                if (r == 0) {
                    return new NotSatisfiableByteRange(value, contentLength);
                }
                range[r++] = Long.parseLong(value.substring(offset, i).trim());
            }
            if (r == 0 || range[0] == -1L && range[1] == -1L) {
                return new NotSatisfiableByteRange(value, contentLength);
            }
            long start = range[0];
            long end = range[1];
            if (start == -1L) {
                start = contentLength - end;
                end = contentLength - 1L;
            }
            if (end == -1L || end > contentLength - 1L) {
                end = contentLength - 1L;
            }
            if (start > end) {
                return new NotSatisfiableByteRange(value, contentLength);
            }
            long limit = end - start + 1L;
            return new SingleByteRange(value, start, limit, limit, "bytes " + start + "-" + end + "/" + contentLength);
        }
        catch (NumberFormatException expected) {
            return new NotSatisfiableByteRange(value, contentLength);
        }
    }

    public long getStart();

    public long getEnd();

    public long getContentLength();

    @NonNull
    public String getContentRange();

    @NonNull
    public StatusCode getStatusCode();

    @NonNull
    public ByteRange apply(@NonNull Context var1);

    @NonNull
    public InputStream apply(@NonNull InputStream var1) throws IOException;
}

