/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.Cookie;
import io.jooby.FileDownload;
import io.jooby.FileUpload;
import io.jooby.FlashMap;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.ParamLookup;
import io.jooby.ParamSource;
import io.jooby.QueryString;
import io.jooby.Registry;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Sender;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.exception.TypeMismatchException;
import io.jooby.internal.LocaleUtils;
import io.jooby.internal.ParamLookupImpl;
import io.jooby.internal.ReadOnlyContext;
import io.jooby.internal.WebSocketSender;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

public interface Context
extends Registry {
    public static final int PORT = 80;
    public static final int SECURE_PORT = 443;
    public static final String ACCEPT = "Accept";
    public static final ZoneId GMT = ZoneId.of("GMT");
    public static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final DateTimeFormatter RFC1123 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).withZone(GMT);

    @NonNull
    public Map<String, Object> getAttributes();

    @Nullable
    public <T> T getAttribute(@NonNull String var1);

    @NonNull
    public Context setAttribute(@NonNull String var1, Object var2);

    @NonNull
    public Router getRouter();

    @NonNull
    public DataBufferFactory getBufferFactory();

    @NonNull
    public Object forward(@NonNull String var1);

    @NonNull
    default public <T> T convert(@NonNull ValueNode value, @NonNull Class<T> type) {
        T result = this.convertOrNull(value, type);
        if (result == null) {
            throw new TypeMismatchException(value.name(), type);
        }
        return result;
    }

    @Nullable
    public <T> T convertOrNull(@NonNull ValueNode var1, @NonNull Class<T> var2);

    @NonNull
    public FlashMap flash();

    @NonNull
    public Value flash(@NonNull String var1);

    @NonNull
    public Session session();

    @NonNull
    public Value session(@NonNull String var1);

    @Nullable
    public Session sessionOrNull();

    @NonNull
    public Value cookie(@NonNull String var1);

    @NonNull
    public Map<String, String> cookieMap();

    @NonNull
    public String getMethod();

    @NonNull
    public Context setMethod(@NonNull String var1);

    @NonNull
    public Route getRoute();

    public boolean matches(@NonNull String var1);

    @NonNull
    public Context setRoute(@NonNull Route var1);

    @NonNull
    default public String getContextPath() {
        return this.getRouter().getContextPath();
    }

    @NonNull
    public String getRequestPath();

    @NonNull
    public Context setRequestPath(@NonNull String var1);

    @NonNull
    public Value path(@NonNull String var1);

    @NonNull
    public <T> T path(@NonNull Class<T> var1);

    @NonNull
    public ValueNode path();

    @NonNull
    public Map<String, String> pathMap();

    @NonNull
    public Context setPathMap(@NonNull Map<String, String> var1);

    @NonNull
    public QueryString query();

    @NonNull
    public ValueNode query(@NonNull String var1);

    @NonNull
    public String queryString();

    @NonNull
    public <T> T query(@NonNull Class<T> var1);

    @NonNull
    public Map<String, String> queryMap();

    @NonNull
    public ValueNode header();

    @NonNull
    public Value header(@NonNull String var1);

    @NonNull
    public Map<String, String> headerMap();

    public boolean accept(@NonNull MediaType var1);

    @Nullable
    public MediaType accept(@NonNull List<MediaType> var1);

    @Nullable
    public MediaType getRequestType();

    default public boolean isPreflight() {
        return this.getMethod().equals("OPTIONS") && !this.header("Access-Control-Request-Method").isMissing();
    }

    @NonNull
    public MediaType getRequestType(MediaType var1);

    public long getRequestLength();

    @NonNull
    default public List<Locale> locales(BiFunction<List<Locale.LanguageRange>, List<Locale>, List<Locale>> filter) {
        return filter.apply(this.header("Accept-Language").toOptional().flatMap(LocaleUtils::parseRanges).orElseGet(Collections::emptyList), this.getRouter().getLocales());
    }

    @NonNull
    default public List<Locale> locales() {
        return this.locales(Locale::filter);
    }

    @NonNull
    default public Locale locale(BiFunction<List<Locale.LanguageRange>, List<Locale>, Locale> filter) {
        return filter.apply(this.header("Accept-Language").toOptional().flatMap(LocaleUtils::parseRanges).orElseGet(Collections::emptyList), this.getRouter().getLocales());
    }

    @NonNull
    default public Locale locale() {
        return this.locale((priorityList, locales) -> Optional.ofNullable(Locale.lookup(priorityList, locales)).orElse((Locale)locales.get(0)));
    }

    @Nullable
    public <T> T getUser();

    @NonNull
    public Context setUser(@Nullable Object var1);

    @NonNull
    public String getRequestURL();

    @NonNull
    public String getRequestURL(@NonNull String var1);

    @NonNull
    public String getRemoteAddress();

    @NonNull
    public Context setRemoteAddress(@NonNull String var1);

    @NonNull
    public String getHost();

    @NonNull
    public Context setHost(@NonNull String var1);

    @NonNull
    public String getHostAndPort();

    public int getPort();

    @NonNull
    public Context setPort(int var1);

    @NonNull
    public String getProtocol();

    @NonNull
    public List<Certificate> getClientCertificates();

    public int getServerPort();

    @NonNull
    public String getServerHost();

    public boolean isSecure();

    @NonNull
    public String getScheme();

    @NonNull
    public Context setScheme(@NonNull String var1);

    @NonNull
    public Formdata form();

    @NonNull
    public ValueNode form(@NonNull String var1);

    @NonNull
    public <T> T form(@NonNull Class<T> var1);

    @NonNull
    public Map<String, String> formMap();

    @NonNull
    public List<FileUpload> files();

    @NonNull
    public List<FileUpload> files(@NonNull String var1);

    @NonNull
    public FileUpload file(@NonNull String var1);

    default public Value lookup(String name) {
        return this.lookup(name, ParamSource.PATH, ParamSource.QUERY, ParamSource.FORM);
    }

    default public Value lookup(@NonNull String name, ParamSource ... sources) {
        if (sources.length == 0) {
            throw new IllegalArgumentException("No parameter sources were specified.");
        }
        return Arrays.stream(sources).map(source -> source.provider.apply(this, name)).filter(value -> !value.isMissing()).findFirst().orElseGet(() -> Value.missing(name));
    }

    default public ParamLookup lookup() {
        return new ParamLookupImpl(this);
    }

    @NonNull
    public Body body();

    @NonNull
    public <T> T body(@NonNull Class<T> var1);

    @NonNull
    public <T> T body(@NonNull Type var1);

    @NonNull
    public <T> T decode(@NonNull Type var1, @NonNull MediaType var2);

    @NonNull
    public MessageDecoder decoder(@NonNull MediaType var1);

    public boolean isInIoThread();

    @NonNull
    public Context dispatch(@NonNull Runnable var1);

    @NonNull
    public Context dispatch(@NonNull Executor var1, @NonNull Runnable var2);

    @NonNull
    public Context detach(@NonNull Route.Handler var1) throws Exception;

    @NonNull
    public Context upgrade(@NonNull WebSocket.Initializer var1);

    @NonNull
    public Context upgrade(@NonNull ServerSentEmitter.Handler var1);

    @NonNull
    public Context setResponseHeader(@NonNull String var1, @NonNull Date var2);

    @NonNull
    public Context setResponseHeader(@NonNull String var1, @NonNull Instant var2);

    @NonNull
    public Context setResponseHeader(@NonNull String var1, @NonNull Object var2);

    @NonNull
    public Context setResponseHeader(@NonNull String var1, @NonNull String var2);

    @NonNull
    public Context removeResponseHeader(@NonNull String var1);

    @NonNull
    public Context removeResponseHeaders();

    @NonNull
    public Context setResponseLength(long var1);

    @Nullable
    public String getResponseHeader(@NonNull String var1);

    public long getResponseLength();

    @NonNull
    public Context setResponseCookie(@NonNull Cookie var1);

    @NonNull
    public Context setResponseType(@NonNull String var1);

    @NonNull
    public Context setResponseType(@NonNull MediaType var1);

    @NonNull
    public Context setResponseType(@NonNull MediaType var1, @Nullable Charset var2);

    @NonNull
    public Context setDefaultResponseType(@NonNull MediaType var1);

    @NonNull
    public MediaType getResponseType();

    @NonNull
    public Context setResponseCode(@NonNull StatusCode var1);

    @NonNull
    public Context setResponseCode(int var1);

    @NonNull
    public StatusCode getResponseCode();

    @NonNull
    public Context render(@NonNull Object var1);

    @NonNull
    public OutputStream responseStream();

    @NonNull
    public OutputStream responseStream(@NonNull MediaType var1);

    @NonNull
    public Context responseStream(@NonNull MediaType var1, @NonNull SneakyThrows.Consumer<OutputStream> var2) throws Exception;

    @NonNull
    public Context responseStream(@NonNull SneakyThrows.Consumer<OutputStream> var1) throws Exception;

    @NonNull
    public Sender responseSender();

    @NonNull
    public PrintWriter responseWriter();

    @NonNull
    public PrintWriter responseWriter(@NonNull MediaType var1);

    @NonNull
    public PrintWriter responseWriter(@NonNull MediaType var1, @Nullable Charset var2);

    @NonNull
    public Context responseWriter(@NonNull SneakyThrows.Consumer<PrintWriter> var1) throws Exception;

    @NonNull
    public Context responseWriter(@NonNull MediaType var1, @NonNull SneakyThrows.Consumer<PrintWriter> var2) throws Exception;

    @NonNull
    public Context responseWriter(@NonNull MediaType var1, @Nullable Charset var2, @NonNull SneakyThrows.Consumer<PrintWriter> var3) throws Exception;

    @NonNull
    public Context sendRedirect(@NonNull String var1);

    @NonNull
    public Context sendRedirect(@NonNull StatusCode var1, @NonNull String var2);

    @NonNull
    public Context send(@NonNull String var1);

    @NonNull
    public Context send(@NonNull String var1, @NonNull Charset var2);

    @NonNull
    public Context send(@NonNull byte[] var1);

    @NonNull
    public Context send(@NonNull ByteBuffer var1);

    @NonNull
    public Context send(@NonNull DataBuffer var1);

    @NonNull
    public Context send(byte[] ... var1);

    @NonNull
    public Context send(@NonNull ByteBuffer[] var1);

    @NonNull
    public Context send(@NonNull ReadableByteChannel var1);

    @NonNull
    public Context send(@NonNull InputStream var1);

    @NonNull
    public Context send(@NonNull FileDownload var1);

    @NonNull
    public Context send(@NonNull Path var1);

    @NonNull
    public Context send(@NonNull FileChannel var1);

    @NonNull
    public Context send(@NonNull StatusCode var1);

    @NonNull
    public Context sendError(@NonNull Throwable var1);

    @NonNull
    public Context sendError(@NonNull Throwable var1, @NonNull StatusCode var2);

    public boolean isResponseStarted();

    public boolean getResetHeadersOnError();

    @NonNull
    public Context setResetHeadersOnError(boolean var1);

    @NonNull
    public Context onComplete(@NonNull Route.Complete var1);

    @NonNull
    public static Context readOnly(@NonNull Context ctx) {
        return new ReadOnlyContext(ctx);
    }

    @NonNull
    public static Context websocket(@NonNull Context ctx, @NonNull WebSocket ws, boolean binary, WebSocket.WriteCallback callback) {
        return new WebSocketSender(ctx, ws, binary, callback);
    }
}

