/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.SameSite;
import io.jooby.SneakyThrows;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Cookie {
    public static final String HMAC_SHA256 = "HmacSHA256";
    private static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US).withZone(ZoneId.of("GMT"));
    private String name;
    private String value;
    private String domain;
    private String path;
    private boolean httpOnly;
    private boolean secure;
    private long maxAge = -1L;
    private SameSite sameSite;

    public Cookie(@NonNull String name, @Nullable String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(@NonNull String name) {
        this(name, null);
    }

    private Cookie(@NonNull Cookie cookie) {
        this.domain = cookie.domain;
        this.value = cookie.value;
        this.name = cookie.name;
        this.maxAge = cookie.maxAge;
        this.path = cookie.path;
        this.secure = cookie.secure;
        this.httpOnly = cookie.httpOnly;
        this.sameSite = cookie.sameSite;
    }

    @NonNull
    public Cookie clone() {
        return new Cookie(this);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Cookie setName(@NonNull String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @NonNull
    public Cookie setValue(@NonNull String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @NonNull
    public String getDomain(@NonNull String domain) {
        return this.domain == null ? domain : domain;
    }

    @NonNull
    public Cookie setDomain(@NonNull String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @NonNull
    public String getPath(@NonNull String path) {
        return this.path == null ? path : this.path;
    }

    @NonNull
    public Cookie setPath(@NonNull String path) {
        this.path = path;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    @NonNull
    public Cookie setSecure(boolean secure) {
        if (this.sameSite != null && this.sameSite.requiresSecure() && !secure) {
            throw new IllegalArgumentException("Cookies with SameSite=" + this.sameSite.getValue() + " must be flagged as Secure. Call Cookie.setSameSite(...) with an argument allowing non-secure cookies before calling Cookie.setSecure(false).");
        }
        this.secure = secure;
        return this;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    @NonNull
    public Cookie setMaxAge(@NonNull Duration maxAge) {
        return this.setMaxAge(maxAge.getSeconds());
    }

    @NonNull
    public Cookie setMaxAge(long maxAge) {
        this.maxAge = maxAge >= 0L ? maxAge : -1L;
        return this;
    }

    @Nullable
    public SameSite getSameSite() {
        return this.sameSite;
    }

    public Cookie setSameSite(@Nullable SameSite sameSite) {
        if (sameSite != null && sameSite.requiresSecure() && !this.isSecure()) {
            throw new IllegalArgumentException("Cookies with SameSite=" + sameSite.getValue() + " must be flagged as Secure. Call Cookie.setSecure(true) before calling Cookie.setSameSite(...).");
        }
        this.sameSite = sameSite;
        return this;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name).append("=");
        if (this.value != null) {
            buff.append(this.value);
        }
        return buff.toString();
    }

    @NonNull
    public String toCookieString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, this.name);
        sb.append("=");
        if (this.value != null) {
            this.append(sb, this.value);
        }
        if (this.path != null) {
            sb.append(";Path=");
            this.append(sb, this.path);
        }
        if (this.domain != null) {
            sb.append(";Domain=");
            this.append(sb, this.domain);
        }
        if (this.sameSite != null) {
            sb.append(";SameSite=");
            this.append(sb, this.sameSite.getValue());
        }
        if (this.secure) {
            sb.append(";Secure");
        }
        if (this.httpOnly) {
            sb.append(";HttpOnly");
        }
        if (this.maxAge >= 0L) {
            sb.append(";Max-Age=").append(this.maxAge);
            long expires = this.maxAge > 0L ? System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.maxAge) : 0L;
            sb.append(";Expires=").append(fmt.format(Instant.ofEpochMilli(expires)));
        }
        return sb.toString();
    }

    @NonNull
    public static String sign(@NonNull String value, @NonNull String secret) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(new SecretKeySpec(secret.getBytes(), HMAC_SHA256));
            byte[] bytes = mac.doFinal(value.getBytes());
            return Base64.getEncoder().withoutPadding().encodeToString(bytes) + "|" + value;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Nullable
    public static String unsign(@NonNull String value, @NonNull String secret) {
        int sep = value.indexOf("|");
        if (sep <= 0) {
            return null;
        }
        String str = value.substring(sep + 1);
        return Cookie.sign(str, secret).equals(value) ? str : null;
    }

    @NonNull
    public static String encode(@Nullable Map<String, String> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return "";
        }
        try {
            StringBuilder joiner = new StringBuilder();
            String enc = StandardCharsets.UTF_8.name();
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                joiner.append(URLEncoder.encode(attribute.getKey(), enc)).append('=').append(URLEncoder.encode(attribute.getValue(), enc)).append('&');
            }
            if (joiner.length() > 0) {
                joiner.setLength(joiner.length() - 1);
            }
            return joiner.toString();
        }
        catch (UnsupportedEncodingException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @NonNull
    public static Map<String, String> decode(@Nullable String value) {
        if (value == null || value.length() == 0) {
            return Collections.emptyMap();
        }
        try {
            int end;
            HashMap<String, String> attributes = new HashMap<String, String>();
            String enc = StandardCharsets.UTF_8.name();
            int start = 0;
            int len = value.length();
            do {
                int eq;
                if ((end = value.indexOf(38, start + 1)) < 0) {
                    end = len;
                }
                if ((eq = value.indexOf(61, start)) <= 0 || eq >= len - 1) continue;
                attributes.put(URLDecoder.decode(value.substring(start, eq), enc), URLDecoder.decode(value.substring(eq + 1, end), enc));
            } while ((start = end + 1) < len);
            return attributes.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
        }
        catch (UnsupportedEncodingException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @NonNull
    public static Optional<Cookie> create(@NonNull String namespace, @NonNull Config conf) {
        if (conf.hasPath(namespace)) {
            Cookie cookie = new Cookie(conf.getString(namespace + ".name"));
            Cookie.value(conf, namespace + ".value", Config::getString, cookie::setValue);
            Cookie.value(conf, namespace + ".path", Config::getString, cookie::setPath);
            Cookie.value(conf, namespace + ".domain", Config::getString, cookie::setDomain);
            Cookie.value(conf, namespace + ".secure", Config::getBoolean, cookie::setSecure);
            Cookie.value(conf, namespace + ".httpOnly", Config::getBoolean, cookie::setHttpOnly);
            Cookie.value(conf, namespace + ".maxAge", (c, path) -> c.getDuration((String)path, TimeUnit.SECONDS), cookie::setMaxAge);
            Cookie.value(conf, namespace + ".sameSite", (c, path) -> SameSite.of(c.getString((String)path)), cookie::setSameSite);
            return Optional.of(cookie);
        }
        return Optional.empty();
    }

    private static <T> void value(Config conf, String name, BiFunction<Config, String, T> mapper, Consumer<T> consumer) {
        if (conf.hasPath(name)) {
            consumer.accept(mapper.apply(conf, name));
        }
    }

    private void append(StringBuilder sb, String str) {
        if (Cookie.needQuote(str)) {
            sb.append('\"');
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            sb.append('\"');
        } else {
            sb.append(str);
        }
    }

    private static boolean needQuote(String value) {
        if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '\"' && c != ',' && c != ';' && c != '\\' && c != ' ' && c != '\t') continue;
            return true;
        }
        return false;
    }
}

