/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.ErrorHandler;
import io.jooby.FileDownload;
import io.jooby.FileUpload;
import io.jooby.FlashMap;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.ServiceKey;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.exception.RegistryException;
import io.jooby.internal.HashValue;
import io.jooby.internal.MissingValue;
import io.jooby.internal.SingleValue;
import io.jooby.internal.UrlParser;
import io.jooby.internal.ValueConverters;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public interface DefaultContext
extends Context {
    @Override
    @NonNull
    default public <T> T require(@NonNull Class<T> type, @NonNull String name) throws RegistryException {
        return this.getRouter().require(type, name);
    }

    @Override
    @NonNull
    default public <T> T require(@NonNull Class<T> type) throws RegistryException {
        return this.getRouter().require(type);
    }

    @Override
    @NonNull
    default public <T> T require(@NonNull ServiceKey<T> key) throws RegistryException {
        return this.getRouter().require(key);
    }

    @Override
    @Nullable
    default public <T> T getUser() {
        return (T)this.getAttributes().get("user");
    }

    @Override
    @NonNull
    default public Context setUser(@Nullable Object user) {
        this.getAttributes().put("user", user);
        return this;
    }

    @Override
    default public boolean matches(String pattern) {
        return this.getRouter().match(pattern, this.getRequestPath());
    }

    @Override
    @Nullable
    default public <T> T getAttribute(@NonNull String key) {
        Object attribute = this.getAttributes().get(key);
        if (attribute == null) {
            Map<String, Object> globals = this.getRouter().getAttributes();
            attribute = globals.get(key);
        }
        return (T)attribute;
    }

    @Override
    @NonNull
    default public Context setAttribute(@NonNull String key, Object value) {
        this.getAttributes().put(key, value);
        return this;
    }

    @Override
    @NonNull
    default public FlashMap flash() {
        return (FlashMap)this.getAttributes().computeIfAbsent("flash", key -> FlashMap.create(this, this.getRouter().getFlashCookie().clone()));
    }

    @Override
    @NonNull
    default public Value flash(@NonNull String name) {
        return Value.create((Context)this, name, (String)this.flash().get(name));
    }

    @Override
    @NonNull
    default public Value session(@NonNull String name) {
        Session session = this.sessionOrNull();
        if (session != null) {
            return session.get(name);
        }
        return Value.missing(name);
    }

    @Override
    @NonNull
    default public Session session() {
        Session session = this.sessionOrNull();
        if (session == null) {
            SessionStore store = this.getRouter().getSessionStore();
            session = store.newSession(this);
            this.getAttributes().put("session", session);
        }
        return session;
    }

    @Override
    @Nullable
    default public Session sessionOrNull() {
        Router router;
        SessionStore store;
        Session session = (Session)this.getAttributes().get("session");
        if (session == null && (session = (store = (router = this.getRouter()).getSessionStore()).findSession(this)) != null) {
            this.getAttributes().put("session", session);
        }
        return session;
    }

    @Override
    @NonNull
    default public Object forward(@NonNull String path) {
        try {
            this.setRequestPath(path);
            Router.Match match = this.getRouter().match(this);
            return match.execute(this, match.route().getHandler());
        }
        catch (Throwable cause) {
            throw SneakyThrows.propagate(cause);
        }
    }

    @Override
    @NonNull
    default public Value cookie(@NonNull String name) {
        String value = this.cookieMap().get(name);
        return value == null ? Value.missing(name) : Value.value(this, name, value);
    }

    @Override
    @NonNull
    default public Value path(@NonNull String name) {
        String value = this.pathMap().get(name);
        return value == null ? new MissingValue(name) : new SingleValue(this, name, UrlParser.decodePathSegment(value));
    }

    @Override
    @NonNull
    default public <T> T path(@NonNull Class<T> type) {
        return this.path().to(type);
    }

    @Override
    @NonNull
    default public ValueNode path() {
        HashValue path = new HashValue(this, null);
        for (Map.Entry<String, String> entry : this.pathMap().entrySet()) {
            path.put(entry.getKey(), entry.getValue());
        }
        return path;
    }

    @Override
    @NonNull
    default public ValueNode query(@NonNull String name) {
        return this.query().get(name);
    }

    @Override
    @NonNull
    default public String queryString() {
        return this.query().queryString();
    }

    @Override
    @NonNull
    default public <T> T query(@NonNull Class<T> type) {
        return this.query().to(type);
    }

    @Override
    @NonNull
    default public Map<String, String> queryMap() {
        return this.query().toMap();
    }

    @Override
    @NonNull
    default public Value header(@NonNull String name) {
        return this.header().get(name);
    }

    @Override
    @NonNull
    default public Map<String, String> headerMap() {
        return this.header().toMap();
    }

    @Override
    default public boolean accept(@NonNull MediaType contentType) {
        return Objects.equals(this.accept(Collections.singletonList(contentType)), contentType);
    }

    @Override
    default public MediaType accept(@NonNull List<MediaType> produceTypes) {
        Value accept = this.header("Accept");
        if (accept.isMissing()) {
            return produceTypes.isEmpty() ? null : produceTypes.get(0);
        }
        List acceptTypes = accept.toList().stream().flatMap(value -> MediaType.parse(value).stream()).distinct().sorted().collect(Collectors.toList());
        int idx = Integer.MAX_VALUE;
        MediaType result = null;
        block0: for (MediaType produceType : produceTypes) {
            for (int i = 0; i < acceptTypes.size(); ++i) {
                MediaType acceptType = (MediaType)acceptTypes.get(i);
                if (!produceType.matches(acceptType) || i >= idx) continue;
                result = produceType;
                idx = i;
                continue block0;
            }
        }
        return result;
    }

    @Override
    @NonNull
    default public String getRequestURL() {
        return this.getRequestURL(this.getRequestPath() + this.queryString());
    }

    @Override
    @NonNull
    default public String getRequestURL(@NonNull String path) {
        String contextPath;
        String scheme = this.getScheme();
        String host = this.getHost();
        int port = this.getPort();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(host);
        if (port > 0 && port != 80 && port != 443) {
            url.append(":").append(port);
        }
        if (!(contextPath = this.getContextPath()).equals("/") && !path.startsWith(contextPath)) {
            url.append(contextPath);
        }
        url.append(path);
        return url.toString();
    }

    @Override
    @Nullable
    default public MediaType getRequestType() {
        Value contentType = this.header("Content-Type");
        return contentType.isMissing() ? null : MediaType.valueOf(contentType.value());
    }

    @Override
    @NonNull
    default public MediaType getRequestType(MediaType defaults) {
        Value contentType = this.header("Content-Type");
        return contentType.isMissing() ? defaults : MediaType.valueOf(contentType.value());
    }

    @Override
    default public long getRequestLength() {
        Value contentLength = this.header("Content-Length");
        return contentLength.isMissing() ? -1L : contentLength.longValue();
    }

    @Override
    @Nullable
    default public String getHostAndPort() {
        String host;
        Optional<String> header = this.getRouter().isTrustProxy() ? this.header("X-Forwarded-Host").toOptional() : Optional.empty();
        String value = header.orElseGet(() -> Optional.ofNullable(this.header("Host").valueOrNull()).orElseGet(() -> this.getServerHost() + ":" + this.getServerPort()));
        int i = value.indexOf(44);
        String string = host = i > 0 ? value.substring(0, i).trim() : value;
        if (host.startsWith("[") && host.endsWith("]")) {
            return host.substring(1, host.length() - 1).trim();
        }
        return host;
    }

    @Override
    @NonNull
    default public String getServerHost() {
        String host = this.getRouter().getServerOptions().getHost();
        return host.equals("0.0.0.0") ? "localhost" : host;
    }

    @Override
    default public int getServerPort() {
        ServerOptions options = this.getRouter().getServerOptions();
        return this.isSecure() ? Optional.ofNullable(options.getSecurePort()).orElse(options.getPort()).intValue() : options.getPort();
    }

    @Override
    default public int getPort() {
        String hostAndPort = this.getHostAndPort();
        if (hostAndPort != null) {
            int index = hostAndPort.indexOf(58);
            if (index > 0) {
                return Integer.parseInt(hostAndPort.substring(index + 1));
            }
            return this.isSecure() ? 443 : 80;
        }
        return this.getServerPort();
    }

    @Override
    @NonNull
    default public String getHost() {
        String hostAndPort = this.getHostAndPort();
        if (hostAndPort != null) {
            int index = hostAndPort.indexOf(58);
            return index > 0 ? hostAndPort.substring(0, index).trim() : hostAndPort;
        }
        return this.getServerHost();
    }

    @Override
    default public boolean isSecure() {
        return this.getScheme().equals("https");
    }

    @Override
    @NonNull
    default public ValueNode form(@NonNull String name) {
        return this.form().get(name);
    }

    @Override
    @NonNull
    default public <T> T form(@NonNull Class<T> type) {
        return this.form().to(type);
    }

    @Override
    @NonNull
    default public Map<String, String> formMap() {
        return this.form().toMap();
    }

    @Override
    @NonNull
    default public List<FileUpload> files() {
        return this.form().files();
    }

    @Override
    @NonNull
    default public List<FileUpload> files(@NonNull String name) {
        return this.form().files(name);
    }

    @Override
    @NonNull
    default public FileUpload file(@NonNull String name) {
        return this.form().file(name);
    }

    @Override
    @NonNull
    default public <T> T body(@NonNull Class<T> type) {
        return this.body().to(type);
    }

    @Override
    @NonNull
    default public <T> T body(@NonNull Type type) {
        return this.body().to(type);
    }

    @Override
    @NonNull
    default public <T> T convertOrNull(@NonNull ValueNode value, @NonNull Class<T> type) {
        return ValueConverters.convert(value, type, this.getRouter());
    }

    @Override
    @NonNull
    default public <T> T decode(@NonNull Type type, @NonNull MediaType contentType) {
        try {
            if (MediaType.text.equals(contentType)) {
                Object result = ValueConverters.convert(this.body(), type, this.getRouter());
                return result;
            }
            return (T)this.decoder(contentType).decode(this, type);
        }
        catch (Exception x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    default public MessageDecoder decoder(@NonNull MediaType contentType) {
        return this.getRoute().decoder(contentType);
    }

    @Override
    @NonNull
    default public Context setResponseHeader(@NonNull String name, @NonNull Date value) {
        return this.setResponseHeader(name, RFC1123.format(Instant.ofEpochMilli(value.getTime())));
    }

    @Override
    @NonNull
    default public Context setResponseHeader(@NonNull String name, @NonNull Instant value) {
        return this.setResponseHeader(name, RFC1123.format(value));
    }

    @Override
    @NonNull
    default public Context setResponseHeader(@NonNull String name, @NonNull Object value) {
        if (value instanceof Date) {
            return this.setResponseHeader(name, (Date)value);
        }
        if (value instanceof Instant) {
            return this.setResponseHeader(name, (Instant)value);
        }
        return this.setResponseHeader(name, value.toString());
    }

    @Override
    @NonNull
    default public Context setResponseType(@NonNull MediaType contentType) {
        return this.setResponseType(contentType, contentType.getCharset());
    }

    @Override
    @NonNull
    default public Context setResponseCode(@NonNull StatusCode statusCode) {
        return this.setResponseCode(statusCode.value());
    }

    @Override
    @NonNull
    default public Context render(@NonNull Object value) {
        try {
            Route route = this.getRoute();
            MessageEncoder encoder = route.getEncoder();
            DataBuffer bytes = encoder.encode(this, value);
            if (bytes == null) {
                if (!this.isResponseStarted()) {
                    throw new IllegalStateException("The response was not encoded");
                }
            } else {
                this.send(bytes);
            }
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    default public OutputStream responseStream(@NonNull MediaType contentType) {
        this.setResponseType(contentType);
        return this.responseStream();
    }

    @Override
    @NonNull
    default public Context responseStream(@NonNull MediaType contentType, @NonNull SneakyThrows.Consumer<OutputStream> consumer) throws Exception {
        this.setResponseType(contentType);
        return this.responseStream(consumer);
    }

    @Override
    @NonNull
    default public Context responseStream(@NonNull SneakyThrows.Consumer<OutputStream> consumer) throws Exception {
        try (OutputStream out = this.responseStream();){
            consumer.accept(out);
        }
        return this;
    }

    @Override
    @NonNull
    default public PrintWriter responseWriter() {
        return this.responseWriter(MediaType.text);
    }

    @Override
    @NonNull
    default public PrintWriter responseWriter(@NonNull MediaType contentType) {
        return this.responseWriter(contentType, contentType.getCharset());
    }

    @Override
    @NonNull
    default public Context responseWriter(@NonNull SneakyThrows.Consumer<PrintWriter> consumer) throws Exception {
        return this.responseWriter(MediaType.text, consumer);
    }

    @Override
    @NonNull
    default public Context responseWriter(@NonNull MediaType contentType, @NonNull SneakyThrows.Consumer<PrintWriter> consumer) throws Exception {
        return this.responseWriter(contentType, contentType.getCharset(), consumer);
    }

    @Override
    @NonNull
    default public Context responseWriter(@NonNull MediaType contentType, @Nullable Charset charset, @NonNull SneakyThrows.Consumer<PrintWriter> consumer) throws Exception {
        try (PrintWriter writer = this.responseWriter(contentType, charset);){
            consumer.accept(writer);
        }
        return this;
    }

    @Override
    @NonNull
    default public Context sendRedirect(@NonNull String location) {
        return this.sendRedirect(StatusCode.FOUND, location);
    }

    @Override
    @NonNull
    default public Context sendRedirect(@NonNull StatusCode redirect, @NonNull String location) {
        this.setResponseHeader("location", location);
        return this.send(redirect);
    }

    @Override
    @NonNull
    default public Context send(byte[] ... data) {
        ByteBuffer[] buffer = new ByteBuffer[data.length];
        for (int i = 0; i < data.length; ++i) {
            buffer[i] = ByteBuffer.wrap(data[i]);
        }
        return this.send(buffer);
    }

    @Override
    @NonNull
    default public Context send(@NonNull String data) {
        return this.send(data, StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    default public Context send(@NonNull FileDownload file) {
        this.setResponseHeader("Content-Disposition", file.getContentDisposition());
        InputStream content = file.stream();
        long length = file.getFileSize();
        if (length > 0L) {
            this.setResponseLength(length);
        }
        this.setDefaultResponseType(file.getContentType());
        if (content instanceof FileInputStream) {
            this.send(((FileInputStream)content).getChannel());
        } else {
            this.send(content);
        }
        return this;
    }

    @Override
    @NonNull
    default public Context send(@NonNull Path file) {
        try {
            this.setDefaultResponseType(MediaType.byFile(file));
            return this.send(FileChannel.open(file, new OpenOption[0]));
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    default public Context sendError(@NonNull Throwable cause) {
        this.sendError(cause, this.getRouter().errorCode(cause));
        return this;
    }

    @Override
    @NonNull
    default public Context sendError(@NonNull Throwable cause, @NonNull StatusCode code) {
        Router router = this.getRouter();
        Logger log = router.getLog();
        if (this.isResponseStarted()) {
            log.error(ErrorHandler.errorMessage(this, code), cause);
        } else {
            try {
                if (this.getResetHeadersOnError()) {
                    this.removeResponseHeaders();
                }
                this.setResponseCode(code);
                router.getErrorHandler().apply(this, cause, code);
            }
            catch (Exception x) {
                if (!this.isResponseStarted()) {
                    ErrorHandler.create().apply(this, cause, code);
                }
                if (Server.connectionLost(x)) {
                    log.debug("error handler resulted in a exception while processing `{}`", (Object)cause.toString(), (Object)x);
                }
                log.error("error handler resulted in a exception while processing `{}`", (Object)cause.toString(), (Object)x);
            }
        }
        if (SneakyThrows.isFatal(cause)) {
            throw SneakyThrows.propagate(cause);
        }
        return this;
    }

    @Override
    @NonNull
    default public DataBufferFactory getBufferFactory() {
        return this.getRouter().getBufferFactory();
    }
}

