/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.EnvironmentOptions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Environment {
    private final List<String> actives;
    private Config config;
    private final ClassLoader classLoader;

    public Environment(@NonNull ClassLoader classLoader, @NonNull Config config, String ... actives) {
        this(classLoader, config, Arrays.asList(actives));
    }

    public Environment(@NonNull ClassLoader classLoader, @NonNull Config config, @NonNull List<String> actives) {
        this.classLoader = classLoader;
        this.actives = actives.stream().map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
        this.config = config;
    }

    @NonNull
    public String getProperty(@NonNull String key, @NonNull String defaults) {
        if (Environment.hasPath(this.config, key)) {
            return this.config.getString(key);
        }
        return defaults;
    }

    @Nullable
    public String getProperty(@NonNull String key) {
        if (Environment.hasPath(this.config, key)) {
            return this.config.getString(key);
        }
        return null;
    }

    @NonNull
    public Map<String, String> getProperties(@NonNull String key) {
        return this.getProperties(key, key);
    }

    @NonNull
    public Map<String, String> getProperties(@NonNull String key, @Nullable String prefix) {
        if (Environment.hasPath(this.config, key)) {
            HashMap<String, String> settings = new HashMap<String, String>();
            String p = prefix == null || prefix.length() == 0 ? "" : prefix + ".";
            this.config.getConfig(key).entrySet().stream().forEach(e -> {
                Object value = ((ConfigValue)e.getValue()).unwrapped();
                if (value instanceof List) {
                    value = ((List)value).stream().collect(Collectors.joining(", "));
                }
                String k = p + (String)e.getKey();
                settings.put(k, value.toString());
            });
            return settings;
        }
        return Collections.emptyMap();
    }

    @NonNull
    public Config getConfig() {
        return this.config;
    }

    public Environment setConfig(@NonNull Config config) {
        this.config = config;
        return this;
    }

    @NonNull
    public List<String> getActiveNames() {
        return Collections.unmodifiableList(this.actives);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(@NonNull String name, String ... names) {
        if (this.actives.contains(name.toLowerCase())) return true;
        if (!Stream.of(names).map(String::toLowerCase).anyMatch(this.actives::contains)) return false;
        return true;
    }

    @NonNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @NonNull
    public Optional<Class> loadClass(@NonNull String className) {
        try {
            return Optional.of(this.classLoader.loadClass(className));
        }
        catch (ClassNotFoundException x) {
            return Optional.empty();
        }
    }

    public String toString() {
        return this.actives + "; " + this.toString(this.config).trim();
    }

    private String toString(Config conf) {
        return this.configTree(conf.origin().description());
    }

    private String configTree(String description) {
        return Stream.of(description.split(":\\s+\\d+,|,")).map(it -> it.replace("merge of", "")).collect(Collectors.joining(" > "));
    }

    private static boolean hasPath(Config config, String key) {
        try {
            return config.hasPath(key);
        }
        catch (ConfigException x) {
            return false;
        }
    }

    @NonNull
    public static Config systemProperties() {
        return ConfigFactory.parseProperties(System.getProperties(), ConfigParseOptions.defaults().setOriginDescription("system properties"));
    }

    @NonNull
    public static Config systemEnv() {
        return ConfigFactory.systemEnvironment();
    }

    @NonNull
    public static Environment loadEnvironment(@NonNull EnvironmentOptions options) {
        Config envConfig;
        String env;
        String extension;
        Config sys = Environment.systemProperties().withFallback(Environment.systemEnv());
        List<String> actives = options.getActiveNames();
        String filename = options.getFilename();
        int ext = filename.lastIndexOf(46);
        if (ext <= 0) {
            extension = ".conf";
        } else {
            extension = filename.substring(ext);
            filename = filename.substring(0, ext);
        }
        Path userdir = Paths.get(System.getProperty("user.dir"), new String[0]);
        String[] names = new String[actives.size() + 1];
        for (int i = 0; i < actives.size(); ++i) {
            names[i] = filename + "." + actives.get(i).trim().toLowerCase() + extension;
        }
        names[actives.size()] = filename + extension;
        Config application = Environment.resolveConfig(options, userdir, names);
        if (application.hasPath("application.env") && !actives.contains(env = application.getString("application.env")) && actives.contains("dev") && actives.size() == 1 && (envConfig = Environment.resolveConfig(options, userdir, filename + "." + env.toLowerCase() + extension)) != null) {
            application = envConfig.withFallback(application);
            actives = Collections.singletonList(env.toLowerCase());
        }
        Config result = sys.withFallback(application).withFallback(Environment.defaults()).resolve();
        return new Environment(options.getClassLoader(), result, actives);
    }

    private static Config resolveConfig(@NonNull EnvironmentOptions options, Path userdir, String ... names) {
        String[] cpdirs;
        Path[] rootdirs;
        Config application = ConfigFactory.empty();
        String basedir = options.getBasedir();
        if (basedir == null) {
            rootdirs = new Path[]{userdir.resolve("conf"), userdir};
            cpdirs = new String[]{"conf", ""};
        } else {
            rootdirs = new Path[]{Paths.get(basedir, new String[0])};
            cpdirs = new String[]{basedir};
        }
        for (String name : names) {
            Config it = Environment.fileConfig(rootdirs, name);
            if (it == null) {
                it = Environment.classpathConfig(options.getClassLoader(), cpdirs, name);
            }
            if (it == null) continue;
            application = application.withFallback(it);
        }
        return application;
    }

    @NonNull
    public static Config defaults() {
        Path tmpdir = Paths.get(System.getProperty("user.dir"), "tmp");
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        defaultMap.put("application.tmpdir", tmpdir.toString());
        defaultMap.put("application.charset", "UTF-8");
        String pid = Environment.pid();
        if (pid != null) {
            System.setProperty("PID", pid);
            defaultMap.put("application.pid", pid);
        }
        return ConfigFactory.parseMap(defaultMap, "defaults");
    }

    @Nullable
    public static String pid() {
        String pid = System.getenv().getOrDefault("PID", System.getProperty("PID"));
        if (pid == null) {
            return Long.valueOf(ProcessHandle.current().pid()).toString();
        }
        return pid;
    }

    private static Config fileConfig(Path[] basedirs, String name) {
        for (Path basedir : basedirs) {
            Path file = basedir.resolve(name);
            if (!Files.exists(file, new LinkOption[0])) continue;
            return ConfigFactory.parseFile(file.toFile());
        }
        return null;
    }

    private static Config classpathConfig(ClassLoader classLoader, String[] basedirs, String name) {
        for (String basedir : basedirs) {
            String file = basedir.isEmpty() ? name : Stream.concat(Stream.of(basedir.split("/")), Stream.of(name)).collect(Collectors.joining("/"));
            Config config = ConfigFactory.parseResources(classLoader, file);
            if (config.isEmpty()) continue;
            return config;
        }
        return null;
    }
}

