/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class EnvironmentOptions {
    private String basedir;
    private String filename;
    private ClassLoader classLoader;
    private String[] activeNames;

    public EnvironmentOptions() {
        this.setFilename("application.conf");
    }

    public List<String> getActiveNames() {
        return this.activeNames == null ? EnvironmentOptions.defaultEnvironmentNames() : Arrays.asList(this.activeNames);
    }

    @NonNull
    public EnvironmentOptions setActiveNames(String ... activeNames) {
        this.activeNames = activeNames;
        return this;
    }

    @NonNull
    public EnvironmentOptions setActiveNames(@NonNull List<String> activeNames) {
        this.activeNames = activeNames.toArray(new String[0]);
        return this;
    }

    @NonNull
    static List<String> defaultEnvironmentNames() {
        return Arrays.asList(System.getProperty("application.env", System.getenv().getOrDefault("application.env", "dev")).split("\\s*,\\s*"));
    }

    @NonNull
    public ClassLoader getClassLoader() {
        return this.classLoader == null ? this.getClass().getClassLoader() : this.classLoader;
    }

    @NonNull
    public ClassLoader getClassLoader(@NonNull ClassLoader defaultClassLoader) {
        return this.classLoader == null ? defaultClassLoader : this.classLoader;
    }

    @NonNull
    public EnvironmentOptions setClassLoader(@NonNull ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Nullable
    public String getBasedir() {
        return this.basedir;
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    @NonNull
    public EnvironmentOptions setBasedir(@Nullable String basedir) {
        this.basedir = basedir;
        return this;
    }

    @NonNull
    public EnvironmentOptions setBasedir(@Nullable Path basedir) {
        this.basedir = basedir.toAbsolutePath().toString();
        return this;
    }

    @NonNull
    public EnvironmentOptions setFilename(@NonNull String filename) {
        this.filename = filename;
        return this;
    }
}

