/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileDownload {
    private static final String CONTENT_DISPOSITION = "%s;filename=\"%s\"";
    private static final String FILENAME_STAR = ";filename*=%s''%s";
    private static final String CHARSET = "UTF-8";
    private final long fileSize;
    private final MediaType contentType;
    private final String fileName;
    private final String contentDisposition;
    private final InputStream content;

    public FileDownload(Mode mode, @NonNull InputStream content, @NonNull String fileName, long fileSize) {
        try {
            this.fileName = Paths.get(fileName, new String[0]).getFileName().toString();
            this.contentType = MediaType.byFile(this.fileName);
            String filenameStar = URLEncoder.encode(this.fileName, CHARSET).replaceAll("\\+", "%20");
            this.contentDisposition = this.fileName.equals(filenameStar) ? String.format(CONTENT_DISPOSITION, mode.value, this.fileName) : String.format(CONTENT_DISPOSITION, mode.value, this.fileName) + String.format(FILENAME_STAR, CHARSET, filenameStar);
            this.content = content;
            this.fileSize = fileSize;
        }
        catch (UnsupportedEncodingException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    public FileDownload(Mode mode, @NonNull InputStream content, @NonNull String fileName) {
        this(mode, content, fileName, -1L);
    }

    public FileDownload(Mode mode, @NonNull byte[] content, @NonNull String fileName) {
        this(mode, new ByteArrayInputStream(content), fileName, content.length);
    }

    public FileDownload(Mode mode, @NonNull Path file, @NonNull String fileName) throws IOException {
        this(mode, new FileInputStream(file.toFile()), fileName, Files.size(file));
    }

    public FileDownload(Mode mode, @NonNull Path file) throws IOException {
        this(mode, file, file.getFileName().toString());
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public InputStream stream() {
        return this.content;
    }

    public String toString() {
        return this.fileName;
    }

    public static Builder build(@NonNull InputStream content, @NonNull String fileName, long fileSize) {
        return mode -> new FileDownload(mode, content, fileName, fileSize);
    }

    public static Builder build(@NonNull InputStream content, @NonNull String fileName) {
        return mode -> new FileDownload(mode, content, fileName);
    }

    public static Builder build(@NonNull byte[] content, @NonNull String fileName) {
        return mode -> new FileDownload(mode, content, fileName);
    }

    public static Builder build(@NonNull Path file, @NonNull String fileName) {
        return mode -> {
            try {
                return new FileDownload(mode, file, fileName);
            }
            catch (IOException e) {
                throw SneakyThrows.propagate(e);
            }
        };
    }

    public static Builder build(@NonNull Path file) {
        return mode -> {
            try {
                return new FileDownload(mode, file);
            }
            catch (IOException e) {
                throw SneakyThrows.propagate(e);
            }
        };
    }

    public static enum Mode {
        INLINE("inline"),
        ATTACHMENT("attachment");

        final String value;

        private Mode(String value) {
            this.value = value;
        }
    }

    public static interface Builder {
        public FileDownload build(Mode var1);

        default public FileDownload attachment() {
            return this.build(Mode.ATTACHMENT);
        }

        default public FileDownload inline() {
            return this.build(Mode.INLINE);
        }
    }
}

