/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.BeanConverter;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Environment;
import io.jooby.EnvironmentOptions;
import io.jooby.ErrorHandler;
import io.jooby.ExecutionMode;
import io.jooby.Extension;
import io.jooby.LoggingService;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.MvcExtension;
import io.jooby.MvcFactory;
import io.jooby.Registry;
import io.jooby.Route;
import io.jooby.RouteSet;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.ServerSentEmitter;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StartupSummary;
import io.jooby.StatusCode;
import io.jooby.Usage;
import io.jooby.ValueConverter;
import io.jooby.WebSocket;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.exception.RegistryException;
import io.jooby.exception.StartupException;
import io.jooby.internal.LocaleUtils;
import io.jooby.internal.MutedServer;
import io.jooby.internal.RegistryRef;
import io.jooby.internal.RouterImpl;
import jakarta.inject.Provider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jooby
implements Router,
Registry {
    static final String APP_NAME = "___app_name__";
    private static final String JOOBY_RUN_HOOK = "___jooby_run_hook__";
    private final transient AtomicBoolean started = new AtomicBoolean(true);
    private final transient AtomicBoolean stopped = new AtomicBoolean(false);
    private static Jooby owner;
    private static ExecutionMode BOOT_EXECUTION_MODE;
    private RouterImpl router;
    private ExecutionMode mode = BOOT_EXECUTION_MODE;
    private Path tmpdir;
    private List<SneakyThrows.Runnable> readyCallbacks;
    private List<SneakyThrows.Runnable> startingCallbacks;
    private LinkedList<AutoCloseable> stopCallbacks;
    private List<Extension> lateExtensions;
    private Environment env;
    private RegistryRef registry = new RegistryRef();
    private ServerOptions serverOptions;
    private List<StartupSummary> startupSummary;
    private EnvironmentOptions environmentOptions;
    private List<Locale> locales;
    private boolean lateInit;
    private String name;
    private String basePackage;
    private String version;
    private Server server;

    public Jooby() {
        if (owner == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.environmentOptions = new EnvironmentOptions().setClassLoader(classLoader);
            this.router = new RouterImpl();
            this.stopCallbacks = new LinkedList();
            this.startingCallbacks = new ArrayList<SneakyThrows.Runnable>();
            this.readyCallbacks = new ArrayList<SneakyThrows.Runnable>();
            this.lateExtensions = new ArrayList<Extension>();
        } else {
            Jooby.copyState(owner, this);
        }
    }

    @Override
    @Nullable
    public ServerOptions getServerOptions() {
        return this.serverOptions;
    }

    @NonNull
    public Jooby setServerOptions(@NonNull ServerOptions serverOptions) {
        this.serverOptions = serverOptions;
        return this;
    }

    @Override
    @NonNull
    public Set<RouterOption> getRouterOptions() {
        return this.router.getRouterOptions();
    }

    @Override
    @NonNull
    public Jooby setRouterOptions(RouterOption ... options) {
        this.router.setRouterOptions(options);
        return this;
    }

    @Override
    @NonNull
    public Environment getEnvironment() {
        if (this.env == null) {
            this.env = Environment.loadEnvironment(this.environmentOptions);
        }
        return this.env;
    }

    @Override
    @Nullable
    public List<Locale> getLocales() {
        return this.locales;
    }

    public Router setLocales(@NonNull List<Locale> locales) {
        this.locales = Objects.requireNonNull(locales);
        return this;
    }

    public Router setLocales(Locale ... locales) {
        return this.setLocales(Arrays.asList(locales));
    }

    @NonNull
    public ClassLoader getClassLoader() {
        return this.env == null ? this.environmentOptions.getClassLoader() : this.env.getClassLoader();
    }

    @Override
    @NonNull
    public Config getConfig() {
        return this.getEnvironment().getConfig();
    }

    @NonNull
    public Jooby setEnvironment(@NonNull Environment environment) {
        this.env = environment;
        return this;
    }

    @NonNull
    public Environment setEnvironmentOptions(@NonNull EnvironmentOptions options) {
        this.environmentOptions = options;
        this.env = Environment.loadEnvironment(options.setClassLoader(options.getClassLoader(this.getClass().getClassLoader())));
        return this.env;
    }

    @NonNull
    public Jooby onStarting(@NonNull SneakyThrows.Runnable body) {
        this.startingCallbacks.add(body);
        return this;
    }

    @NonNull
    public Jooby onStarted(@NonNull SneakyThrows.Runnable body) {
        this.readyCallbacks.add(body);
        return this;
    }

    @NonNull
    public Jooby onStop(@NonNull AutoCloseable body) {
        this.stopCallbacks.addFirst(body);
        return this;
    }

    @Override
    @NonNull
    public Jooby setContextPath(@NonNull String basePath) {
        this.router.setContextPath(basePath);
        return this;
    }

    @Override
    @NonNull
    public String getContextPath() {
        return this.router.getContextPath();
    }

    @NonNull
    public Jooby install(@NonNull SneakyThrows.Supplier<Jooby> factory) {
        return this.install("/", factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Jooby install(@NonNull String path, @NonNull SneakyThrows.Supplier<Jooby> factory) {
        try {
            owner = this;
            this.path(path, factory::get);
            Jooby jooby = this;
            return jooby;
        }
        finally {
            owner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Jooby install(@NonNull String path, @NonNull Predicate<Context> predicate, @NonNull SneakyThrows.Supplier<Jooby> factory) {
        try {
            owner = this;
            this.router.install(path, predicate, factory);
            Jooby jooby = this;
            return jooby;
        }
        finally {
            owner = null;
        }
    }

    @NonNull
    public Jooby install(@NonNull Predicate<Context> predicate, @NonNull SneakyThrows.Supplier<Jooby> factory) {
        return this.install("/", predicate, factory);
    }

    @NonNull
    public Router getRouter() {
        return this.router;
    }

    @Override
    public boolean isTrustProxy() {
        return this.router.isTrustProxy();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    @NonNull
    public Jooby setTrustProxy(boolean trustProxy) {
        this.router.setTrustProxy(trustProxy);
        return this;
    }

    @Override
    @NonNull
    public Router domain(@NonNull String domain, @NonNull Router subrouter) {
        this.router.domain(domain, subrouter);
        return this;
    }

    @Override
    @NonNull
    public RouteSet domain(@NonNull String domain, @NonNull Runnable body) {
        return this.router.domain(domain, body);
    }

    @Override
    @NonNull
    public RouteSet mount(@NonNull Predicate<Context> predicate, @NonNull Runnable body) {
        return this.router.mount(predicate, body);
    }

    @Override
    @NonNull
    public Jooby mount(@NonNull Predicate<Context> predicate, @NonNull Router subrouter) {
        this.router.mount(predicate, subrouter);
        return this;
    }

    @Override
    @NonNull
    public Jooby mount(@NonNull String path, @NonNull Router router) {
        this.router.mount(path, router);
        if (router instanceof Jooby) {
            Jooby child = (Jooby)router;
            child.registry = this.registry;
        }
        return this;
    }

    @Override
    @NonNull
    public Jooby mount(@NonNull Router router) {
        return this.mount("/", router);
    }

    @Override
    @NonNull
    public Jooby mvc(@NonNull MvcExtension router) {
        try {
            router.install(this);
            return this;
        }
        catch (Exception cause) {
            throw SneakyThrows.propagate(cause);
        }
    }

    @Override
    @NonNull
    public Jooby mvc(@NonNull Object router) {
        Provider<Object> provider = () -> router;
        return this.mvc((Class)router.getClass(), (Provider)provider);
    }

    @Override
    @NonNull
    public Jooby mvc(@NonNull Class router) {
        return this.mvc(router, () -> this.require(router));
    }

    @Override
    @NonNull
    public <T> Jooby mvc(@NonNull Class<T> router, @NonNull Provider<T> provider) {
        try {
            MvcFactory<Object> module = this.loadModule(router);
            Extension extension = module.create(provider::get);
            extension.install(this);
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate(x);
        }
    }

    private <T> MvcFactory<T> loadModule(Class<T> router) {
        try {
            ServiceLoader<MvcFactory> modules = ServiceLoader.load(MvcFactory.class);
            return StreamSupport.stream(modules.spliterator(), false).filter(it -> it.supports(router)).findFirst().orElseGet(() -> this.mvcReflectionFallback(router, this.getClassLoader()));
        }
        catch (ServiceConfigurationError notfound) {
            return this.mvcReflectionFallback(router, this.getClassLoader());
        }
    }

    @Override
    @NonNull
    public Route ws(@NonNull String pattern, @NonNull WebSocket.Initializer handler) {
        return this.router.ws(pattern, handler);
    }

    @Override
    @NonNull
    public Route sse(@NonNull String pattern, @NonNull ServerSentEmitter.Handler handler) {
        return this.router.sse(pattern, handler);
    }

    @Override
    @NonNull
    public List<Route> getRoutes() {
        return this.router.getRoutes();
    }

    @Override
    @NonNull
    public Jooby error(@NonNull ErrorHandler handler) {
        this.router.error(handler);
        return this;
    }

    @Override
    @NonNull
    public Router use(@NonNull Route.Filter filter) {
        this.router.use(filter);
        return this;
    }

    @Override
    @NonNull
    public Jooby before(@NonNull Route.Before before) {
        this.router.before(before);
        return this;
    }

    @Override
    @NonNull
    public Jooby after(@NonNull Route.After after) {
        this.router.after(after);
        return this;
    }

    @Override
    @NonNull
    public Jooby encoder(@NonNull MessageEncoder encoder) {
        this.router.encoder(encoder);
        return this;
    }

    @Override
    @NonNull
    public Jooby decoder(@NonNull MediaType contentType, @NonNull MessageDecoder decoder) {
        this.router.decoder(contentType, decoder);
        return this;
    }

    @Override
    @NonNull
    public Jooby encoder(@NonNull MediaType contentType, @NonNull MessageEncoder encoder) {
        this.router.encoder(contentType, encoder);
        return this;
    }

    @NonNull
    public Jooby install(@NonNull Extension extension) {
        if (this.lateInit || extension.lateinit()) {
            this.lateExtensions.add(extension);
        } else {
            try {
                extension.install(this);
            }
            catch (Exception x) {
                throw SneakyThrows.propagate(x);
            }
        }
        return this;
    }

    @NonNull
    public Jooby install(@NonNull Server server) {
        this.server = server;
        return this;
    }

    @Override
    @NonNull
    public Jooby dispatch(@NonNull Runnable body) {
        this.router.dispatch(body);
        return this;
    }

    @Override
    @NonNull
    public Jooby dispatch(@NonNull Executor executor, @NonNull Runnable action) {
        this.router.dispatch(executor, action);
        return this;
    }

    @Override
    @NonNull
    public RouteSet path(@NonNull String pattern, @NonNull Runnable action) {
        return this.router.path(pattern, action);
    }

    @Override
    @NonNull
    public RouteSet routes(@NonNull Runnable action) {
        return this.router.routes(action);
    }

    @Override
    @NonNull
    public Route route(@NonNull String method, @NonNull String pattern, @NonNull Route.Handler handler) {
        return this.router.route(method, pattern, handler);
    }

    @Override
    @NonNull
    public Router.Match match(@NonNull Context ctx) {
        return this.router.match(ctx);
    }

    @Override
    public boolean match(@NonNull String pattern, @NonNull String path) {
        return this.router.match(pattern, path);
    }

    @Override
    @NonNull
    public Jooby errorCode(@NonNull Class<? extends Throwable> type, @NonNull StatusCode statusCode) {
        this.router.errorCode(type, statusCode);
        return this;
    }

    @Override
    @NonNull
    public StatusCode errorCode(@NonNull Throwable cause) {
        return this.router.errorCode(cause);
    }

    @Override
    @NonNull
    public Executor getWorker() {
        return this.router.getWorker();
    }

    @Override
    @NonNull
    public Jooby setWorker(@NonNull Executor worker) {
        this.router.setWorker(worker);
        if (worker instanceof ExecutorService) {
            this.onStop(((ExecutorService)worker)::shutdown);
        }
        return this;
    }

    @Override
    @NonNull
    public Jooby setDefaultWorker(@NonNull Executor worker) {
        this.router.setDefaultWorker(worker);
        return this;
    }

    @Override
    @NonNull
    public DataBufferFactory getBufferFactory() {
        return this.router.getBufferFactory();
    }

    @Override
    @NonNull
    public Jooby setBufferFactory(@NonNull DataBufferFactory bufferFactory) {
        this.router.setBufferFactory(bufferFactory);
        return this;
    }

    @Override
    @NonNull
    public Logger getLog() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @NonNull
    public ErrorHandler getErrorHandler() {
        return this.router.getErrorHandler();
    }

    @Override
    @NonNull
    public Path getTmpdir() {
        if (this.tmpdir == null) {
            this.tmpdir = Paths.get(this.getEnvironment().getConfig().getString("application.tmpdir"), new String[0]).toAbsolutePath();
        }
        return this.tmpdir;
    }

    @NonNull
    public Jooby setTmpdir(@NonNull Path tmpdir) {
        this.tmpdir = tmpdir;
        return this;
    }

    @NonNull
    public ExecutionMode getExecutionMode() {
        return this.mode;
    }

    @NonNull
    public Jooby setExecutionMode(@NonNull ExecutionMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> getAttributes() {
        return this.router.getAttributes();
    }

    @Override
    @NonNull
    public Jooby attribute(@NonNull String key, @NonNull Object value) {
        this.router.attribute(key, value);
        return this;
    }

    @Override
    @NonNull
    public <T> T attribute(@NonNull String key) {
        return this.router.attribute(key);
    }

    @Override
    @NonNull
    public <T> T require(@NonNull Class<T> type, @NonNull String name) {
        return this.require(ServiceKey.key(type, name));
    }

    @Override
    @NonNull
    public <T> T require(@NonNull Class<T> type) {
        return this.require(ServiceKey.key(type));
    }

    @Override
    @NonNull
    public <T> T require(@NonNull ServiceKey<T> key) {
        ServiceRegistry services = this.getServices();
        T service = services.getOrNull(key);
        if (service == null) {
            if (!this.registry.isSet()) {
                throw new RegistryException("Service not found: " + key);
            }
            String name = key.getName();
            return name == null ? this.registry.get().require(key.getType()) : this.registry.get().require(key.getType(), name);
        }
        return service;
    }

    @NonNull
    public Jooby registry(@NonNull Registry registry) {
        this.registry.set(registry);
        return this;
    }

    @Override
    @NonNull
    public ServiceRegistry getServices() {
        return this.router.getServices();
    }

    @Nullable
    public String getBasePackage() {
        if (this.basePackage == null) {
            this.basePackage = System.getProperty("application.package", Optional.ofNullable(this.getClass().getPackage()).map(Package::getName).orElse(null));
        }
        return this.basePackage;
    }

    @NonNull
    public Jooby setBasePackage(@Nullable String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    @Override
    @NonNull
    public SessionStore getSessionStore() {
        return this.router.getSessionStore();
    }

    @Override
    @NonNull
    public Jooby setSessionStore(@NonNull SessionStore store) {
        this.router.setSessionStore(store);
        return this;
    }

    @Override
    @NonNull
    public Jooby executor(@NonNull String name, @NonNull Executor executor) {
        if (executor instanceof ExecutorService) {
            this.onStop(((ExecutorService)executor)::shutdown);
        }
        this.router.executor(name, executor);
        return this;
    }

    @Override
    @NonNull
    public Cookie getFlashCookie() {
        return this.router.getFlashCookie();
    }

    @Override
    @NonNull
    public Jooby setFlashCookie(@NonNull Cookie flashCookie) {
        this.router.setFlashCookie(flashCookie);
        return this;
    }

    @Override
    @NonNull
    public Jooby converter(@NonNull ValueConverter converter) {
        this.router.converter(converter);
        return this;
    }

    @Override
    @NonNull
    public List<ValueConverter> getConverters() {
        return this.router.getConverters();
    }

    @Override
    @NonNull
    public List<BeanConverter> getBeanConverters() {
        return this.router.getBeanConverters();
    }

    @Override
    @NonNull
    public Jooby setHiddenMethod(@NonNull Function<Context, Optional<String>> provider) {
        this.router.setHiddenMethod(provider);
        return this;
    }

    @Override
    @NonNull
    public Jooby setCurrentUser(@NonNull Function<Context, Object> provider) {
        this.router.setCurrentUser(provider);
        return this;
    }

    @Override
    @NonNull
    public Jooby setContextAsService(boolean contextAsService) {
        this.router.setContextAsService(contextAsService);
        return this;
    }

    @Override
    @NonNull
    public Jooby setHiddenMethod(@NonNull String parameterName) {
        this.router.setHiddenMethod(parameterName);
        return this;
    }

    public List<StartupSummary> getStartupSummary() {
        return this.startupSummary;
    }

    public Jooby setStartupSummary(List<StartupSummary> startupSummary) {
        this.startupSummary = startupSummary;
        return this;
    }

    @NonNull
    public Server start() {
        if (this.server == null) {
            this.server = this.loadServer();
        }
        if (!this.server.getLoggerOff().isEmpty()) {
            this.server = MutedServer.mute(this.server, new String[0]);
        }
        try {
            if (this.serverOptions == null) {
                this.serverOptions = ServerOptions.from(this.getEnvironment().getConfig()).orElse(null);
            }
            if (this.serverOptions != null) {
                this.serverOptions.setServer(this.server.getName());
                this.server.setOptions(this.serverOptions);
            }
            return this.server.start(this);
        }
        catch (Throwable startupError) {
            this.stopped.set(true);
            Logger log = this.getLog();
            log.error("Application startup resulted in exception", startupError);
            try {
                this.server.stop();
            }
            catch (Throwable stopError) {
                log.debug("Server stop resulted in exception", stopError);
            }
            throw startupError instanceof StartupException ? (StartupException)startupError : new StartupException("Application startup resulted in exception", startupError);
        }
    }

    private Server loadServer() {
        List<Server> servers = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(Server.class).iterator(), 16), false).toList();
        if (servers.isEmpty()) {
            throw new StartupException("Server not found.");
        }
        if (servers.size() > 1) {
            List names = servers.stream().map(it -> it.getClass().getSimpleName().toLowerCase()).collect(Collectors.toList());
            this.getLog().warn("Multiple servers found {}. Using: {}", (Object)names, names.get(0));
        }
        return servers.get(0);
    }

    @NonNull
    public Jooby start(@NonNull Server server) {
        Path tmpdir = this.getTmpdir();
        Jooby.ensureTmpdir(tmpdir);
        if (this.mode == null) {
            this.mode = ExecutionMode.DEFAULT;
        }
        if (this.locales == null) {
            String path = "application.lang";
            this.locales = Optional.of(this.getConfig()).filter(c -> c.hasPath(path)).map(c -> c.getString(path)).map(v -> LocaleUtils.parseLocales(v).orElseThrow(() -> new RuntimeException(String.format("Invalid value for configuration property '%s'; check the documentation of %s#parse(): %s", path, Locale.LanguageRange.class.getName(), v)))).orElseGet(() -> Collections.singletonList(Locale.getDefault()));
        }
        ServiceRegistry services = this.getServices();
        services.put(Environment.class, this.getEnvironment());
        services.put(Config.class, this.getConfig());
        this.joobyRunHook(this.getClass().getClassLoader(), server);
        for (Extension extension : this.lateExtensions) {
            try {
                extension.install(this);
            }
            catch (Throwable e) {
                throw SneakyThrows.propagate(e);
            }
        }
        this.lateExtensions.clear();
        this.lateExtensions = null;
        this.startingCallbacks = this.fire(this.startingCallbacks);
        this.router.start(this, server);
        return this;
    }

    @NonNull
    public Jooby ready(@NonNull Server server) {
        this.serverOptions = server.getOptions();
        if (this.startupSummary == null) {
            Config config = this.env.getConfig();
            if (config.hasPath("application.startupSummary")) {
                Object value = config.getAnyRef("application.startupSummary");
                List<String> values2 = value instanceof List ? (List<String>)value : List.of(value.toString());
                this.startupSummary = values2.stream().map(StartupSummary::create).collect(Collectors.toUnmodifiableList());
            } else {
                this.startupSummary = List.of(StartupSummary.DEFAULT, StartupSummary.ROUTES);
            }
        }
        this.startupSummary.forEach(summary -> summary.log(this, server));
        this.readyCallbacks = this.fire(this.readyCallbacks);
        return this;
    }

    @NonNull
    public Jooby stop() {
        if (this.started.compareAndSet(true, false)) {
            this.stopped.set(true);
            Logger log = this.getLog();
            log.debug("Stopping {}", (Object)System.getProperty(APP_NAME, this.getClass().getSimpleName()));
            this.router.destroy();
            this.fireStop();
            log.info("Stopped {}", (Object)System.getProperty(APP_NAME, this.getClass().getSimpleName()));
        }
        return this;
    }

    public Jooby setLateInit(boolean lateInit) {
        this.lateInit = lateInit;
        return this;
    }

    @NonNull
    public String getName() {
        if (this.name == null) {
            this.name = System.getProperty(APP_NAME);
            if (this.name == null) {
                this.name = Optional.ofNullable(this.getClass().getPackage()).map(Package::getImplementationTitle).filter(Objects::nonNull).orElse(this.getClass().getSimpleName());
            }
        }
        return this.name;
    }

    @NonNull
    public Jooby setName(@NonNull String name) {
        this.name = name;
        return this;
    }

    @NonNull
    public String getVersion() {
        if (this.version == null) {
            this.version = Optional.ofNullable(this.getClass().getPackage()).map(Package::getImplementationVersion).filter(Objects::nonNull).orElse("0.0.0");
        }
        return this.version;
    }

    @NonNull
    public Jooby setVersion(@NonNull String version) {
        this.version = version;
        return this;
    }

    public String toString() {
        return this.getName() + ":" + this.getVersion();
    }

    public static void runApp(@NonNull String[] args2, @NonNull Supplier<Jooby> provider) {
        Jooby.runApp(args2, ExecutionMode.DEFAULT, provider);
    }

    public static void runApp(@NonNull String[] args2, @NonNull Consumer<Jooby> consumer) {
        Jooby.configurePackage(consumer.getClass().getPackage());
        Jooby.runApp(args2, ExecutionMode.DEFAULT, Jooby.consumerProvider(consumer));
    }

    public static void runApp(@NonNull String[] args2, @NonNull ExecutionMode executionMode, @NonNull Consumer<Jooby> consumer) {
        Jooby.configurePackage(consumer.getClass().getPackage());
        Jooby.runApp(args2, executionMode, Jooby.consumerProvider(consumer));
    }

    public static void runApp(@NonNull String[] args2, @NonNull ExecutionMode executionMode, @NonNull Supplier<Jooby> provider) {
        Jooby.createApp(args2, executionMode, provider).start();
    }

    public static Jooby createApp(@NonNull String[] args2, @NonNull ExecutionMode executionMode, @NonNull Supplier<Jooby> provider) {
        Jooby app;
        Jooby.configurePackage(provider.getClass().getPackage());
        Jooby.parseArguments(args2).forEach(System::setProperty);
        String logfile = LoggingService.configure(provider.getClass().getClassLoader(), new EnvironmentOptions().getActiveNames());
        if (logfile != null) {
            System.setProperty("application.logfile", logfile);
        }
        try {
            BOOT_EXECUTION_MODE = executionMode;
            app = provider.get();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(Jooby.class).error("Application initialization resulted in exception", t);
            throw t instanceof StartupException ? (StartupException)t : new StartupException("Application initialization resulted in exception", t);
        }
        finally {
            BOOT_EXECUTION_MODE = ExecutionMode.DEFAULT;
        }
        return app;
    }

    public boolean problemDetailsIsEnabled() {
        Config config = this.getConfig();
        return config.hasPath("problem.details.enabled") && config.getBoolean("problem.details.enabled");
    }

    private static void configurePackage(Package pkg) {
        if (pkg != null) {
            Jooby.configurePackage(pkg.getName());
        }
    }

    private static void configurePackage(Class owner) {
        if (!owner.getName().equals("io.jooby.Jooby") && !owner.getName().equals("io.jooby.kt.Kooby")) {
            Jooby.configurePackage(owner.getPackage());
        }
    }

    private static void configurePackage(String packageName) {
        Set<String> defaultPackages = Set.of("io.jooby", "io.jooby.kt");
        if (!defaultPackages.contains(packageName)) {
            Jooby.ifSystemProp("application.package", (sys, key) -> sys.setProperty((String)key, packageName));
        }
    }

    private static void ifSystemProp(String name, BiConsumer<Properties, String> consumer) {
        if (System.getProperty(name) == null) {
            consumer.accept(System.getProperties(), name);
        }
    }

    static Map<String, String> parseArguments(String ... args2) {
        if (args2 == null || args2.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> conf = new LinkedHashMap<String, String>();
        for (String arg : args2) {
            int eq = arg.indexOf(61);
            if (eq > 0) {
                conf.put(arg.substring(0, eq).trim(), arg.substring(eq + 1).trim());
                continue;
            }
            conf.putIfAbsent("application.env", arg);
        }
        return conf;
    }

    private static void ensureTmpdir(Path tmpdir) {
        try {
            if (!Files.exists(tmpdir, new LinkOption[0])) {
                Files.createDirectories(tmpdir, new FileAttribute[0]);
            }
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    private List<SneakyThrows.Runnable> fire(List<SneakyThrows.Runnable> tasks) {
        if (tasks != null) {
            Iterator<SneakyThrows.Runnable> iterator2 = tasks.iterator();
            while (iterator2.hasNext()) {
                SneakyThrows.Runnable task = iterator2.next();
                task.run();
                iterator2.remove();
            }
        }
        return null;
    }

    private void fireStop() {
        if (this.stopCallbacks != null) {
            LinkedList<AutoCloseable> tasks = this.stopCallbacks;
            this.stopCallbacks = null;
            Iterator iterator2 = tasks.iterator();
            while (iterator2.hasNext()) {
                AutoCloseable task = (AutoCloseable)iterator2.next();
                try {
                    task.close();
                }
                catch (Exception x) {
                    this.getLog().error("exception found while executing onStop:", x);
                }
                iterator2.remove();
            }
        }
    }

    private static Supplier<Jooby> consumerProvider(Consumer<Jooby> consumer) {
        Jooby.configurePackage(consumer.getClass());
        return () -> {
            Jooby app = new Jooby();
            consumer.accept(app);
            return app;
        };
    }

    private void joobyRunHook(ClassLoader loader, Server server) {
        if (loader.getClass().getName().equals("org.jboss.modules.ModuleClassLoader")) {
            String hookClassname = System.getProperty(JOOBY_RUN_HOOK);
            System.setProperty(JOOBY_RUN_HOOK, "");
            if (hookClassname != null && hookClassname.length() > 0) {
                try {
                    Class<?> serverRefClass = loader.loadClass(hookClassname);
                    Constructor<?> constructor = serverRefClass.getDeclaredConstructor(new Class[0]);
                    Consumer consumer = (Consumer)constructor.newInstance(new Object[0]);
                    consumer.accept(MutedServer.mute(server, new String[0]));
                }
                catch (Exception x) {
                    throw SneakyThrows.propagate(x);
                }
            }
        }
    }

    private MvcFactory mvcReflectionFallback(Class source, ClassLoader classLoader) {
        try {
            String moduleName = source.getName() + "$Module";
            Class<?> moduleType = classLoader.loadClass(moduleName);
            Constructor<?> constructor = moduleType.getDeclaredConstructor(new Class[0]);
            this.getLog().debug("Loading mvc using reflection: " + source);
            return (MvcFactory)constructor.newInstance(new Object[0]);
        }
        catch (Exception x) {
            throw Usage.mvcRouterNotFound(source);
        }
    }

    private static void copyState(Jooby source, Jooby dest) {
        dest.serverOptions = source.serverOptions;
        dest.registry = source.registry;
        dest.mode = source.mode;
        dest.environmentOptions = source.environmentOptions;
        dest.name = source.name;
        dest.version = source.version;
        dest.lateInit = source.lateInit;
        dest.locales = source.locales;
        dest.env = source.getEnvironment();
        dest.router = source.router;
        dest.lateExtensions = source.lateExtensions;
        dest.readyCallbacks = source.readyCallbacks;
        dest.startingCallbacks = source.startingCallbacks;
        dest.stopCallbacks = source.stopCallbacks;
    }

    static {
        BOOT_EXECUTION_MODE = ExecutionMode.DEFAULT;
    }
}

