/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.ServerSentMessage;
import io.jooby.SneakyThrows;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ServerSentEmitter {
    public void onClose(SneakyThrows.Runnable var1);

    @NonNull
    public Context getContext();

    @NonNull
    default public Map<String, Object> getAttributes() {
        return this.getContext().getAttributes();
    }

    @NonNull
    default public <T> T attribute(@NonNull String key) {
        return this.getContext().getAttribute(key);
    }

    @NonNull
    default public ServerSentEmitter attribute(@NonNull String key, Object value) {
        this.getContext().setAttribute(key, value);
        return this;
    }

    @NonNull
    default public ServerSentEmitter send(@NonNull String data) {
        return this.send(new ServerSentMessage(data));
    }

    @NonNull
    default public ServerSentEmitter send(@NonNull byte[] data) {
        return this.send(new ServerSentMessage(data));
    }

    @NonNull
    default public ServerSentEmitter send(@NonNull Object data) {
        if (data instanceof ServerSentMessage) {
            return this.send((ServerSentMessage)data);
        }
        return this.send(new ServerSentMessage(data));
    }

    @NonNull
    default public ServerSentEmitter send(@NonNull String event, @NonNull Object data) {
        return this.send(new ServerSentMessage(data).setEvent(event));
    }

    @NonNull
    public ServerSentEmitter send(@NonNull ServerSentMessage var1);

    @NonNull
    default public ServerSentEmitter keepAlive(long time, @NonNull TimeUnit unit) {
        return this.keepAlive(unit.toMillis(time));
    }

    @NonNull
    public ServerSentEmitter keepAlive(long var1);

    @Nullable
    default public String getLastEventId() {
        return this.lastEventId(String.class);
    }

    @Nullable
    default public <T> T lastEventId(Class<T> type) {
        return this.getContext().header("Last-Event-ID").toOptional(type).orElse(null);
    }

    @NonNull
    public String getId();

    @NonNull
    public ServerSentEmitter setId(@NonNull String var1);

    public boolean isOpen();

    public void close();

    public static interface Handler {
        public void handle(@NonNull ServerSentEmitter var1) throws Exception;
    }

    public static class KeepAlive
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(ServerSentEmitter.class);
        private ServerSentEmitter emitter;
        private long retry;

        public KeepAlive(ServerSentEmitter emitter, long retry) {
            this.emitter = emitter;
            this.retry = retry;
        }

        @Override
        public void run() {
            if (this.emitter.isOpen()) {
                String sseId = this.emitter.getId();
                try {
                    this.log.debug("running heart beat for {}", (Object)sseId);
                    this.emitter.send(":" + sseId + "\n");
                    this.emitter.keepAlive(this.retry);
                }
                catch (Exception x) {
                    this.log.debug("connection lost for {}", (Object)sseId, (Object)x);
                    this.emitter.close();
                }
            }
        }
    }
}

