/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.SneakyThrows;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;

public final class SslOptions
implements Closeable {
    public static final String TLS_V1_2 = "TLSv1.2";
    public static final String TLS_V1_3 = "TLSv1.3";
    public static final String X509 = "X509";
    public static final String PKCS12 = "PKCS12";
    private String password;
    private String type = "PKCS12";
    private InputStream cert;
    private InputStream trustCert;
    private String trustPassword;
    private InputStream privateKey;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private List<String> protocol = Arrays.asList("TLSv1.3", "TLSv1.2");
    private SSLContext sslContext;

    public String getType() {
        return this.type;
    }

    @NonNull
    public SslOptions setType(@NonNull String type) {
        this.type = type;
        return this;
    }

    @NonNull
    public InputStream getCert() {
        return this.cert;
    }

    @NonNull
    public SslOptions setCert(@NonNull InputStream cert) {
        this.cert = cert;
        return this;
    }

    @Nullable
    public InputStream getTrustCert() {
        return this.trustCert;
    }

    @NonNull
    public SslOptions setTrustCert(@Nullable InputStream trustCert) {
        this.trustCert = trustCert;
        return this;
    }

    @Nullable
    public String getTrustPassword() {
        return this.trustPassword;
    }

    @NonNull
    public SslOptions setTrustPassword(@Nullable String password) {
        this.trustPassword = password;
        return this;
    }

    @Nullable
    public InputStream getPrivateKey() {
        return this.privateKey;
    }

    @NonNull
    public SslOptions setPrivateKey(@Nullable InputStream privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Override
    public void close() {
        List resources = Stream.of(this.cert, this.trustCert, this.privateKey).collect(Collectors.toList());
        for (InputStream resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (IOException iOException) {}
        }
        resources.clear();
        this.cert = null;
        this.trustCert = null;
        this.privateKey = null;
    }

    @NonNull
    public SslOptions setPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NonNull
    public static InputStream getResource(@NonNull String path) {
        try {
            Stream<Path> paths;
            Path filepath = Paths.get(path, new String[0]);
            if (Files.exists(filepath, new LinkOption[0])) {
                paths = Stream.of(filepath);
            } else {
                try {
                    paths = Stream.of(Paths.get(System.getProperty("user.dir"), path));
                }
                catch (InvalidPathException cause) {
                    paths = Stream.empty();
                }
            }
            InputStream resource = paths.map(it -> it.normalize().toAbsolutePath()).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(SneakyThrows.throwingFunction(file -> Files.newInputStream(file, new OpenOption[0]))).orElseGet(() -> SslOptions.class.getClassLoader().getResourceAsStream(path.startsWith("/") ? path.substring(1) : path));
            if (resource == null) {
                throw new FileNotFoundException(path);
            }
            return resource;
        }
        catch (IOException cause) {
            throw SneakyThrows.propagate(cause);
        }
    }

    @NonNull
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    @NonNull
    public SslOptions setClientAuth(@NonNull ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @NonNull
    public List<String> getProtocol() {
        return this.protocol;
    }

    @NonNull
    public SslOptions setProtocol(String ... protocol) {
        return this.setProtocol(Arrays.asList(protocol));
    }

    @NonNull
    public SslOptions setProtocol(@NonNull List<String> protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(@Nullable SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String toString() {
        return this.type;
    }

    @NonNull
    public static SslOptions x509(@NonNull String crt, @NonNull String key) {
        return SslOptions.x509(crt, key, null);
    }

    @NonNull
    public static SslOptions x509(@NonNull String crt, @NonNull String key, @Nullable String password) {
        SslOptions options = new SslOptions();
        options.setType(X509);
        options.setPrivateKey(SslOptions.getResource(key));
        options.setCert(SslOptions.getResource(crt));
        options.setPassword(password);
        return options;
    }

    public static SslOptions pkcs12(@NonNull String crt, @NonNull String password) {
        SslOptions options = new SslOptions();
        options.setType(PKCS12);
        options.setCert(SslOptions.getResource(crt));
        options.setPassword(password);
        return options;
    }

    public static SslOptions selfSigned() {
        return SslOptions.selfSigned(PKCS12);
    }

    public static SslOptions selfSigned(String type) {
        switch (type.toUpperCase()) {
            case "PKCS12": {
                return SslOptions.pkcs12("io/jooby/ssl/localhost.p12", "changeit");
            }
            case "X509": {
                return SslOptions.x509("io/jooby/ssl/localhost.crt", "io/jooby/ssl/localhost.key");
            }
        }
        throw new UnsupportedOperationException("SSL type: " + type);
    }

    @NonNull
    public static Optional<SslOptions> from(@NonNull Config conf) {
        return SslOptions.from(conf, "server.ssl", "ssl");
    }

    @NonNull
    public static Optional<SslOptions> from(@NonNull Config conf, String ... key) {
        return Stream.of(key).filter(conf::hasPath).findFirst().map(path -> {
            SslOptions options;
            String type;
            String string = type = conf.hasPath(path + ".type") ? conf.getString(path + ".type").toUpperCase() : PKCS12;
            if (type.equalsIgnoreCase("self-signed")) {
                options = SslOptions.selfSigned();
            } else {
                options = new SslOptions();
                options.setType(type);
                if (X509.equalsIgnoreCase(type)) {
                    options.setCert(SslOptions.getResource(conf.getString(path + ".cert")));
                    options.setPrivateKey(SslOptions.getResource(conf.getString(path + ".key")));
                    if (conf.hasPath(path + ".password")) {
                        options.setPassword(conf.getString(path + ".password"));
                    }
                } else if (type.equalsIgnoreCase(PKCS12)) {
                    options.setCert(SslOptions.getResource(conf.getString(path + ".cert")));
                    options.setPassword(conf.getString(path + ".password"));
                } else {
                    throw new UnsupportedOperationException("SSL type: " + type);
                }
            }
            if (conf.hasPath(path + ".clientAuth")) {
                options.setClientAuth(ClientAuth.valueOf(conf.getString(path + ".clientAuth").toUpperCase()));
            }
            if (conf.hasPath(path + ".trust.cert")) {
                options.setTrustCert(SslOptions.getResource(conf.getString(path + ".trust.cert")));
            }
            if (conf.hasPath(path + ".trust.password")) {
                options.setTrustPassword(conf.getString(path + ".trust.password"));
            }
            if (conf.hasPath(path + ".protocol")) {
                Object value = conf.getAnyRef(path + ".protocol");
                if (value instanceof List) {
                    options.setProtocol((List)value);
                } else {
                    options.setProtocol(value.toString());
                }
            }
            return options;
        });
    }

    public static enum ClientAuth {
        NONE,
        REQUESTED,
        REQUIRED;

    }
}

