/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import io.jooby.Environment;
import io.jooby.Jooby;
import io.jooby.Server;
import io.jooby.ServerOptions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public interface StartupSummary {
    public static final StartupSummary VERBOSE = (application, server) -> {
        Logger logger2 = application.getLog();
        Environment env = application.getEnvironment();
        Config config = application.getConfig();
        logger2.info("{} started with:", (Object)application.getName());
        logger2.info("    PID: {}", (Object)config.getString("application.pid"));
        logger2.info("    {}", (Object)server.getOptions());
        logger2.info("    execution mode: {}", (Object)application.getExecutionMode().name().toLowerCase());
        logger2.info("    environment: {}", (Object)env);
        logger2.info("    app dir: {}", (Object)config.getString("user.dir"));
        logger2.info("    tmp dir: {}", (Object)application.getTmpdir());
        if (config.hasPath("application.logfile")) {
            logger2.info("    log file: {}", (Object)config.getString("application.logfile"));
        }
    };
    public static final StartupSummary DEFAULT = (application, server) -> {
        Logger logger2 = application.getLog();
        Environment env = application.getEnvironment();
        List<String> activeNames = env.getActiveNames();
        String environment = activeNames.size() == 1 ? activeNames.get(0) : activeNames.toString();
        logger2.info("{} ({}) started", (Object)application.getName(), (Object)environment);
    };
    public static final StartupSummary NONE = (application, server) -> {};
    public static final StartupSummary ROUTES = (application, server) -> {
        Logger logger2 = application.getLog();
        ArrayList<Object> args2 = new ArrayList<Object>();
        StringBuilder buff = new StringBuilder();
        buff.append("routes: \n\n{}\n\nlistening on:\n");
        args2.add(application.getRouter());
        ServerOptions options = server.getOptions();
        String host = options.getHost().replace("0.0.0.0", "localhost");
        if (!options.isHttpsOnly()) {
            args2.add(host);
            args2.add(options.getPort());
            args2.add(application.getContextPath());
            buff.append("  http://{}:{}{}\n");
        }
        if (options.isSSLEnabled()) {
            args2.add(host);
            args2.add(options.getSecurePort());
            args2.add(application.getContextPath());
            buff.append("  https://{}:{}{}\n");
        }
        logger2.info(buff.toString(), args2.toArray(new Object[0]));
    };

    public static StartupSummary create(String value) {
        switch (value.toLowerCase()) {
            case "verbose": {
                return VERBOSE;
            }
            case "none": {
                return NONE;
            }
            case "routes": {
                return ROUTES;
            }
        }
        return DEFAULT;
    }

    public void log(Jooby var1, Server var2);
}

