/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.MessageEncoder;
import io.jooby.ModelAndView;
import io.jooby.buffer.DataBuffer;
import java.util.Collections;
import java.util.List;

public interface TemplateEngine
extends MessageEncoder {
    public static final String TEMPLATE_PATH = "templates.path";
    public static final String PATH = "views";

    public DataBuffer render(Context var1, ModelAndView<?> var2) throws Exception;

    @Override
    default public DataBuffer encode(@NonNull Context ctx, @NonNull Object value) throws Exception {
        ctx.flash();
        ctx.sessionOrNull();
        ctx.setDefaultResponseType(MediaType.html);
        return this.render(ctx, (ModelAndView)value);
    }

    default public boolean supports(@NonNull ModelAndView modelAndView) {
        String view = modelAndView.getView();
        for (String extension : this.extensions()) {
            if (!view.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    default public List<String> extensions() {
        return Collections.singletonList(".html");
    }

    @NonNull
    public static String normalizePath(@NonNull String templatesPath) {
        if (templatesPath == null) {
            return null;
        }
        return templatesPath.startsWith("/") ? templatesPath.substring(1) : templatesPath;
    }
}

