/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Value;
import io.jooby.exception.MissingValueException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

public interface ValueNode
extends Iterable<ValueNode>,
Value {
    @NonNull
    public ValueNode get(int var1);

    @NonNull
    public ValueNode get(@NonNull String var1);

    default public int size() {
        return 0;
    }

    @Override
    @NonNull
    default public Iterator<ValueNode> iterator() {
        return Collections.emptyIterator();
    }

    @NonNull
    default public String resolve(@NonNull String expression) {
        return this.resolve(expression, "${", "}");
    }

    @NonNull
    default public String resolve(@NonNull String expression, boolean ignoreMissing) {
        return this.resolve(expression, ignoreMissing, "${", "}");
    }

    @NonNull
    default public String resolve(@NonNull String expression, @NonNull String startDelim, @NonNull String endDelim) {
        return this.resolve(expression, false, startDelim, endDelim);
    }

    @NonNull
    default public String resolve(@NonNull String expression, boolean ignoreMissing, @NonNull String startDelim, @NonNull String endDelim) {
        if (expression.length() == 0) {
            return "";
        }
        BiFunction<Integer, BiFunction, RuntimeException> err = (start, ex) -> {
            String snapshot = expression.substring(0, (int)start);
            int line = Math.max(1, (int)snapshot.chars().filter(ch -> ch == 10).count());
            int column = start - snapshot.lastIndexOf(10);
            return (RuntimeException)ex.apply(line, column);
        };
        StringBuilder buffer = new StringBuilder();
        int offset = 0;
        int start2 = expression.indexOf(startDelim);
        while (start2 >= 0) {
            String value;
            int end = expression.indexOf(endDelim, start2 + startDelim.length());
            if (end == -1) {
                throw err.apply(start2, (line, column) -> new IllegalArgumentException("found '" + startDelim + "' expecting '" + endDelim + "' at " + line + ":" + column));
            }
            buffer.append(expression.substring(offset, start2));
            String key = expression.substring(start2 + startDelim.length(), end);
            try {
                String[] path = key.split("\\.");
                ValueNode src = path[0].equals(this.name()) ? this : this.get(path[0]);
                for (int i = 1; i < path.length; ++i) {
                    src = src.get(path[i]);
                }
                value = src.value();
            }
            catch (MissingValueException x) {
                if (ignoreMissing) {
                    value = expression.substring(start2, end + endDelim.length());
                }
                throw err.apply(start2, (line, column) -> new NoSuchElementException("Missing " + startDelim + key + endDelim + " at " + line + ":" + column));
            }
            buffer.append(value);
            offset = end + endDelim.length();
            start2 = expression.indexOf(startDelim, offset);
        }
        if (buffer.length() == 0) {
            return expression;
        }
        if (offset < expression.length()) {
            buffer.append(expression.substring(offset));
        }
        return buffer.toString();
    }
}

