/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Route;

public class WebVariables
implements Route.Filter {
    private final String scope;

    public WebVariables(@NonNull String scope) {
        this.scope = scope;
    }

    public WebVariables() {
        this.scope = null;
    }

    @Override
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return ctx -> next.apply(this.webvariables(ctx));
    }

    private Context webvariables(Context ctx) {
        String contextPath = ctx.getContextPath();
        ctx.setAttribute(this.key("contextPath"), contextPath.equals("/") ? "" : contextPath);
        ctx.setAttribute(this.key("path"), ctx.getRequestPath());
        Object user = ctx.getUser();
        if (user != null) {
            ctx.setAttribute(this.key("user"), user);
        }
        return ctx;
    }

    private String key(String key) {
        return this.scope == null ? key : this.scope + "." + key;
    }
}

