/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.Context;
import io.jooby.RequestScope;
import io.jooby.exception.RegistryException;
import io.jooby.internal.ContextInitializer;
import jakarta.inject.Provider;

public class ContextAsServiceInitializer
implements ContextInitializer,
Provider<Context> {
    public static final ContextAsServiceInitializer INSTANCE = new ContextAsServiceInitializer();

    private ContextAsServiceInitializer() {
    }

    @Override
    public void apply(Context ctx) {
        RequestScope.bind(this, ctx);
        ctx.onComplete(context -> RequestScope.unbind(this));
    }

    @Override
    public Context get() {
        Context context = (Context)RequestScope.get(this);
        if (context == null) {
            throw new RegistryException("Context is not available. Are you getting it from request scope?");
        }
        return context;
    }
}

