/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.handler.Asset;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileAsset
implements Asset {
    private Path file;

    public FileAsset(@NonNull Path file) {
        this.file = file;
    }

    @Override
    public long getSize() {
        try {
            return Files.size(this.file);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public MediaType getContentType() {
        return MediaType.byFile(this.file);
    }

    @Override
    public InputStream stream() {
        try {
            return new FileInputStream(this.file.toFile());
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.file, new LinkOption[0]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileAsset) {
            return this.file.equals(((FileAsset)obj).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }
}

