/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.ValueNode;
import io.jooby.internal.ArrayValue;
import io.jooby.internal.MissingValue;
import io.jooby.internal.SingleValue;
import io.jooby.internal.ValueConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class HashValue
implements ValueNode {
    protected static final Map<String, ValueNode> EMPTY = Collections.emptyMap();
    private Context ctx;
    protected Map<String, ValueNode> hash = EMPTY;
    private final String name;
    private boolean arrayLike;

    public HashValue(Context ctx, String name) {
        this.ctx = ctx;
        this.name = name;
    }

    protected HashValue(Context ctx) {
        this.ctx = ctx;
        this.name = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void put(String path, String value) {
        this.put(path, Collections.singletonList(value));
    }

    public void put(String path, ValueNode node) {
        this.put(path, (String name, Map<String, ValueNode> scope) -> {
            ValueNode existing = (ValueNode)scope.get(name);
            if (existing == null) {
                scope.put(name, node);
            } else {
                ArrayValue list;
                if (existing instanceof ArrayValue) {
                    list = (ArrayValue)existing;
                } else {
                    list = new ArrayValue(this.ctx, (String)name).add(existing);
                    scope.put(name, list);
                }
                list.add(node);
            }
        });
    }

    public void put(String path, Collection<String> values2) {
        this.put(path, (String name, Map<String, ValueNode> scope) -> {
            for (String value : values2) {
                ArrayValue list;
                ValueNode existing = (ValueNode)scope.get(name);
                if (existing == null) {
                    scope.put(name, new SingleValue(this.ctx, (String)name, this.decode(value)));
                    continue;
                }
                if (existing instanceof ArrayValue) {
                    list = (ArrayValue)existing;
                } else {
                    list = new ArrayValue(this.ctx, (String)name).add(existing);
                    scope.put(name, list);
                }
                list.add(this.decode(value));
            }
        });
    }

    protected String decode(String value) {
        return value;
    }

    private void put(String path, BiConsumer<String, Map<String, ValueNode>> consumer) {
        int nameStart = 0;
        int nameEnd = path.length();
        HashValue target = this;
        for (int i = nameStart; i < nameEnd; ++i) {
            String name;
            char ch = path.charAt(i);
            if (ch == '.') {
                name = path.substring(nameStart, i);
                nameStart = i + 1;
                target = target.getOrCreateScope(name);
                continue;
            }
            if (ch == '[') {
                if (nameStart < i) {
                    name = path.substring(nameStart, i);
                    target = target.getOrCreateScope(name);
                }
                nameStart = i + 1;
                continue;
            }
            if (ch != ']') continue;
            if (i + 1 < nameEnd) {
                name = path.substring(nameStart, i);
                if (this.isNumber(name)) {
                    target.useIndexes();
                }
                nameStart = i + 1;
                target = target.getOrCreateScope(name);
                continue;
            }
            nameEnd = i;
        }
        String key = path.substring(nameStart, nameEnd);
        if (this.isNumber(key)) {
            target.useIndexes();
        }
        consumer.accept(key, target.hash());
    }

    private void useIndexes() {
        if (this.hash instanceof TreeMap) {
            return;
        }
        this.arrayLike = true;
        TreeMap<String, ValueNode> ordered = new TreeMap<String, ValueNode>();
        ordered.putAll(this.hash);
        this.hash.clear();
        this.hash = ordered;
    }

    private boolean isNumber(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected Map<String, ValueNode> hash() {
        if (this.hash == EMPTY) {
            this.hash = new LinkedHashMap<String, ValueNode>();
        }
        return this.hash;
    }

    HashValue getOrCreateScope(String name) {
        return (HashValue)this.hash().computeIfAbsent(name, k -> new HashValue(this.ctx, (String)k));
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        ValueNode value = this.hash.get(name);
        if (value == null) {
            return new MissingValue(this.scope(name));
        }
        return value;
    }

    private String scope(String name) {
        return this.name == null ? name : this.name + "." + name;
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        return this.get(Integer.toString(index));
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public String value() {
        StringJoiner joiner = new StringJoiner("&");
        this.hash.forEach((? super K k, ? super V v) -> {
            for (ValueNode value : v) {
                String str = value instanceof FileUpload ? ((FileUpload)((Object)value)).getFileName() : value.toString();
                joiner.add(k + "=" + str);
            }
        });
        return joiner.toString();
    }

    @Override
    public Iterator<ValueNode> iterator() {
        return this.hash.values().iterator();
    }

    @Override
    @NonNull
    public List<String> toList() {
        return this.toList(String.class);
    }

    @Override
    @NonNull
    public Set<String> toSet() {
        return this.toSet(String.class);
    }

    @Override
    @NonNull
    public <T> List<T> toList(@NonNull Class<T> type) {
        return this.toCollection(type, new ArrayList());
    }

    @Override
    @NonNull
    public <T> Set<T> toSet(@NonNull Class<T> type) {
        return this.toCollection(type, new LinkedHashSet());
    }

    @Override
    @NonNull
    public <T> Optional<T> toOptional(@NonNull Class<T> type) {
        if (this.hash.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.to(type));
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Class<T> type) {
        return this.ctx.convert(this, type);
    }

    @Override
    @Nullable
    public final <T> T toNullable(@NonNull Class<T> type) {
        return this.toNullable(this.ctx, type, this.allowEmptyBean());
    }

    protected <T> T toNullable(@NonNull Context ctx, @NonNull Class<T> type, boolean allowEmpty) {
        return ValueConverters.convert(this, type, ctx.getRouter(), allowEmpty);
    }

    @Override
    public Map<String, List<String>> toMultimap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(this.hash.size());
        Set<Map.Entry<String, ValueNode>> entries = this.hash.entrySet();
        String scope = this.name == null ? "" : this.name + ".";
        for (Map.Entry<String, ValueNode> entry : entries) {
            ValueNode value = entry.getValue();
            value.toMultimap().forEach((? super K k, ? super V v) -> result.put(scope + k, (List<String>)v));
        }
        return result;
    }

    public String toString() {
        return this.hash.toString();
    }

    public void put(Map<String, Collection<String>> headers) {
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private <T, C extends Collection<T>> C toCollection(@NonNull Class<T> type, C collection) {
        if (!this.hash.isEmpty()) {
            if (this.arrayLike) {
                for (Map.Entry<String, ValueNode> e : this.hash.entrySet()) {
                    if (!e.getKey().chars().allMatch(Character::isDigit)) continue;
                    ValueNode valueNode = e.getValue();
                    if (valueNode instanceof HashValue) {
                        HashValue node = (HashValue)valueNode;
                        HashValue.addItem(this.ctx, node, type, collection);
                        continue;
                    }
                    Optional.ofNullable(e.getValue().toNullable(type)).ifPresent(collection::add);
                }
            } else {
                HashValue.addItem(this.ctx, this, type, collection);
            }
        }
        return collection;
    }

    private static <T> void addItem(Context ctx, HashValue node, Class<T> type, Collection<T> container) {
        T item = node.toNullable(ctx, type, false);
        if (item != null) {
            container.add(item);
        }
    }

    protected boolean allowEmptyBean() {
        return false;
    }
}

