/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.ValueNode;
import io.jooby.internal.MissingValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InputStreamBody
implements Body {
    private Context ctx;
    private long length;
    private InputStream in;

    public InputStreamBody(Context ctx, InputStream stream, long contentLength) {
        this.ctx = ctx;
        this.in = stream;
        this.length = contentLength;
    }

    @Override
    public byte[] bytes() {
        byte[] byArray;
        block9: {
            InputStream stream = this.in;
            try {
                int len;
                int bufferSize = 16384;
                ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);
                byte[] buffer = new byte[bufferSize];
                while ((len = stream.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, len);
                }
                byArray = out.toByteArray();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    throw SneakyThrows.propagate(x);
                }
            }
            stream.close();
        }
        return byArray;
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public ReadableByteChannel channel() {
        return Channels.newChannel(this.in);
    }

    @Override
    public long getSize() {
        return this.length;
    }

    @Override
    public InputStream stream() {
        return this.in;
    }

    @Override
    @NonNull
    public String value() {
        return this.value(StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        return index == 0 ? this : this.get(Integer.toString(index));
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        return new MissingValue(name);
    }

    @Override
    public String name() {
        return "body";
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Type type) {
        return this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Type type) {
        return this.ctx.decode(type, this.ctx.getRequestType(MediaType.text));
    }

    @Override
    @NonNull
    public List<String> toList() {
        return Collections.singletonList(this.value());
    }

    @Override
    public Map<String, List<String>> toMultimap() {
        return Collections.emptyMap();
    }
}

