/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.Context;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SessionToken;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MemorySessionStore
extends SessionStore.InMemory {
    private ConcurrentHashMap<String, SessionStore.InMemory.Data> sessions = new ConcurrentHashMap();
    private Duration timeout;

    public MemorySessionStore(SessionToken token, Duration timeout) {
        super(token);
        this.timeout = Optional.ofNullable(timeout).filter(t -> t.toMillis() > 0L).orElse(null);
    }

    @Override
    protected SessionStore.InMemory.Data getOrCreate(String sessionId, Function<String, SessionStore.InMemory.Data> factory) {
        return this.sessions.computeIfAbsent(sessionId, factory);
    }

    @Override
    protected SessionStore.InMemory.Data getOrNull(String sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    protected SessionStore.InMemory.Data remove(String sessionId) {
        return this.sessions.remove(sessionId);
    }

    @Override
    protected void put(String sessionId, SessionStore.InMemory.Data data) {
        this.sessions.put(sessionId, data);
    }

    @Override
    public Session findSession(Context ctx) {
        this.purge();
        return super.findSession(ctx);
    }

    private void purge() {
        if (this.timeout != null) {
            Iterator<Map.Entry<String, SessionStore.InMemory.Data>> iterator2 = this.sessions.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, SessionStore.InMemory.Data> entry = iterator2.next();
                SessionStore.InMemory.Data session = entry.getValue();
                if (!session.isExpired(this.timeout)) continue;
                iterator2.remove();
            }
        }
    }

    public SessionStore setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }
}

