/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.Context;
import io.jooby.SessionToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultipleSessionToken
implements SessionToken {
    private List<SessionToken> sessionTokens;

    public MultipleSessionToken(SessionToken ... sessionToken) {
        this.sessionTokens = Arrays.asList(sessionToken);
    }

    @Override
    public String findToken(Context ctx) {
        for (SessionToken sessionToken : this.sessionTokens) {
            String token = sessionToken.findToken(ctx);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    @Override
    public void saveToken(Context ctx, String token) {
        this.strategy(ctx).forEach(it -> it.saveToken(ctx, token));
    }

    @Override
    public void deleteToken(Context ctx, String token) {
        this.strategy(ctx).forEach(it -> it.deleteToken(ctx, token));
    }

    private List<SessionToken> strategy(Context ctx) {
        ArrayList<SessionToken> result = new ArrayList<SessionToken>(this.sessionTokens.size());
        for (SessionToken sessionToken : this.sessionTokens) {
            if (sessionToken.findToken(ctx) == null) continue;
            result.add(sessionToken);
        }
        return result.isEmpty() ? this.sessionTokens : result;
    }
}

