/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.ByteRange;
import io.jooby.Context;
import io.jooby.StatusCode;
import java.io.IOException;
import java.io.InputStream;

public class NoByteRange
implements ByteRange {
    private long contentLength;

    public NoByteRange(long contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public long getStart() {
        return 0L;
    }

    @Override
    public long getEnd() {
        return this.contentLength;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @NonNull
    public StatusCode getStatusCode() {
        return StatusCode.OK;
    }

    @Override
    @NonNull
    public String getContentRange() {
        return "bytes */" + this.contentLength;
    }

    @Override
    @NonNull
    public ByteRange apply(@NonNull Context ctx) {
        return this;
    }

    @Override
    @NonNull
    public InputStream apply(@NonNull InputStream input) throws IOException {
        return input;
    }
}

