/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.ExecutionMode;
import io.jooby.Route;
import io.jooby.internal.ContextInitializer;
import io.jooby.internal.handler.DefaultHandler;
import io.jooby.internal.handler.DetachHandler;
import io.jooby.internal.handler.DispatchHandler;
import io.jooby.internal.handler.PostDispatchInitializerHandler;
import io.jooby.internal.handler.WorkerHandler;
import java.util.concurrent.Executor;

public class Pipeline {
    public static Route.Handler build(boolean requiresDetach, Route route, ExecutionMode mode, Executor executor, ContextInitializer initializer) {
        Route.Filter pre;
        if (!route.isNonBlockingSet()) {
            route.setNonBlocking(Pipeline.isDefaultNonblocking(executor, mode));
        }
        Route.Filter wrapper = DefaultHandler.DEFAULT;
        if (requiresDetach && route.isNonBlocking()) {
            wrapper = DetachHandler.DETACH.then(wrapper);
        }
        Route.Handler pipeline = route.isNonBlocking() ? ((pre = route.getFilter()) == null ? route.getHandler() : pre.then(route.getHandler())) : route.getPipeline();
        return Pipeline.dispatchHandler(mode, executor, Pipeline.decorate(initializer, wrapper.then(pipeline)), route.isNonBlocking());
    }

    private static boolean isDefaultNonblocking(Executor executor, ExecutionMode mode) {
        return executor == null && mode == ExecutionMode.EVENT_LOOP;
    }

    private static Route.Handler decorate(ContextInitializer initializer, Route.Handler handler) {
        return initializer == null ? handler : new PostDispatchInitializerHandler(initializer).then(handler);
    }

    private static Route.Handler dispatchHandler(ExecutionMode mode, Executor executor, Route.Handler handler, boolean nonblocking) {
        if (executor == null) {
            if (mode == ExecutionMode.WORKER) {
                return WorkerHandler.WORKER.then(handler);
            }
            if (mode == ExecutionMode.DEFAULT && !nonblocking) {
                return WorkerHandler.WORKER.then(handler);
            }
            return handler;
        }
        return new DispatchHandler(executor).apply(handler);
    }
}

