/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.BeanConverter;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Environment;
import io.jooby.ErrorHandler;
import io.jooby.ExecutionMode;
import io.jooby.Jooby;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.MvcExtension;
import io.jooby.Route;
import io.jooby.RouteSet;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.ServerSentEmitter;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.ValueConverter;
import io.jooby.WebSocket;
import io.jooby.XSS;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.buffer.DefaultDataBufferFactory;
import io.jooby.exception.RegistryException;
import io.jooby.exception.StatusCodeException;
import io.jooby.internal.Chi;
import io.jooby.internal.ContextAsServiceInitializer;
import io.jooby.internal.ContextInitializer;
import io.jooby.internal.ContextInitializerList;
import io.jooby.internal.CurrentUserInitializer;
import io.jooby.internal.DefaultHiddenMethodLookup;
import io.jooby.internal.ForwardingExecutor;
import io.jooby.internal.HiddenMethodInitializer;
import io.jooby.internal.HttpMessageEncoder;
import io.jooby.internal.Pipeline;
import io.jooby.internal.RouteTree;
import io.jooby.internal.RouteTreeIgnoreTrailingSlash;
import io.jooby.internal.RouteTreeLowerCasePath;
import io.jooby.internal.RouteTreeNormPath;
import io.jooby.internal.ServiceRegistryImpl;
import io.jooby.internal.ValueConverters;
import io.jooby.internal.handler.ServerSentEventHandler;
import io.jooby.internal.handler.WebSocketHandler;
import io.jooby.problem.ProblemDetailsHandler;
import jakarta.inject.Provider;
import java.io.FileNotFoundException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterImpl
implements Router {
    private static final Route ROUTE_MARK = new Route("GET", "/", null);
    private ErrorHandler err;
    private Map<String, StatusCode> errorCodes;
    private RouteTree chi = new Chi();
    private LinkedList<Stack> stack = new LinkedList();
    private List<Route> routes = new ArrayList<Route>();
    private HttpMessageEncoder encoder = new HttpMessageEncoder();
    private String basePath;
    private Map<Predicate<Context>, RouteTree> predicateMap;
    private Executor worker = new ForwardingExecutor();
    private Map<Route, Executor> routeExecutor = new HashMap<Route, Executor>();
    private Map<String, MessageDecoder> decoders = new HashMap<String, MessageDecoder>();
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private ServiceRegistry services = new ServiceRegistryImpl();
    private SessionStore sessionStore = SessionStore.memory();
    private Cookie flashCookie = new Cookie("jooby.flash").setHttpOnly(true);
    private LinkedList<ValueConverter> converters;
    private List<BeanConverter> beanConverters;
    private ContextInitializer preDispatchInitializer;
    private ContextInitializer postDispatchInitializer;
    private Set<RouterOption> routerOptions = EnumSet.of(RouterOption.RESET_HEADERS_ON_ERROR);
    private DataBufferFactory bufferFactory;
    private boolean trustProxy;
    private boolean contextAsService;
    private boolean started;
    private boolean stopped;

    public RouterImpl() {
        this.stack.addLast(new Stack(this.chi, null));
        this.converters = new LinkedList<ValueConverter>(ValueConverters.defaultConverters());
        this.beanConverters = new ArrayList<BeanConverter>(3);
    }

    @Override
    @NonNull
    public Config getConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Environment getEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<Locale> getLocales() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    @NonNull
    public Set<RouterOption> getRouterOptions() {
        return this.routerOptions;
    }

    @Override
    @NonNull
    public Router setRouterOptions(RouterOption ... options) {
        Stream.of(options).forEach(this.routerOptions::add);
        return this;
    }

    @Override
    @NonNull
    public Router setContextPath(@NonNull String basePath) {
        if (this.routes.size() > 0) {
            throw new IllegalStateException("Base path must be set before adding any routes.");
        }
        this.basePath = Router.leadingSlash(basePath);
        return this;
    }

    @Override
    @NonNull
    public Path getTmpdir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    @Override
    @NonNull
    public String getContextPath() {
        return this.basePath == null ? "/" : this.basePath;
    }

    @Override
    @NonNull
    public List<Route> getRoutes() {
        return this.routes;
    }

    @Override
    public boolean isTrustProxy() {
        return this.trustProxy;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    @NonNull
    public Router setTrustProxy(boolean trustProxy) {
        this.trustProxy = trustProxy;
        if (trustProxy) {
            this.addPreDispatchInitializer(ContextInitializer.PROXY_PEER_ADDRESS);
        } else {
            this.removePreDispatchInitializer(ContextInitializer.PROXY_PEER_ADDRESS);
        }
        return this;
    }

    @Override
    @NonNull
    public RouteSet domain(@NonNull String domain, @NonNull Runnable body) {
        return this.mount(RouterImpl.domainPredicate(domain), body);
    }

    @Override
    @NonNull
    public Router domain(@NonNull String domain, @NonNull Router subrouter) {
        return this.mount(RouterImpl.domainPredicate(domain), subrouter);
    }

    @Override
    @NonNull
    public RouteSet mount(@NonNull Predicate<Context> predicate, @NonNull Runnable body) {
        RouteSet routeSet = new RouteSet();
        Chi tree = new Chi();
        this.putPredicate(predicate, tree);
        int start = this.routes.size();
        this.newStack(tree, "/", body, new Route.Filter[0]);
        routeSet.setRoutes(this.routes.subList(start, this.routes.size()));
        return routeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Router install(@NonNull String path, @NonNull Predicate<Context> predicate, @NonNull SneakyThrows.Supplier<Jooby> factory) {
        RouteTree existingRouter = this.chi;
        try {
            Chi tree = new Chi();
            this.chi = tree;
            this.putPredicate(predicate, tree);
            this.path(path, factory::get);
            RouterImpl routerImpl = this;
            return routerImpl;
        }
        finally {
            this.chi = existingRouter;
        }
    }

    @Override
    @NonNull
    public Router mount(@NonNull Predicate<Context> predicate, @NonNull Router subrouter) {
        this.overrideAll(this, subrouter);
        this.mount(predicate, () -> {
            for (Route route : subrouter.getRoutes()) {
                Route newRoute = this.newRoute(route.getMethod(), route.getPattern(), route.getHandler());
                this.copy(route, newRoute);
            }
        });
        return this;
    }

    @Override
    @NonNull
    public Router mount(@NonNull String path, @NonNull Router router) {
        this.overrideAll(this, router);
        this.mergeErrorHandler(router);
        this.copyRoutes(path, router);
        return this;
    }

    @Override
    @NonNull
    public Router mount(@NonNull Router router) {
        return this.mount("/", router);
    }

    @Override
    @NonNull
    public Router mvc(@NonNull MvcExtension router) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Router mvc(@NonNull Object router) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Router mvc(@NonNull Class router) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public <T> Router mvc(@NonNull Class<T> router, @NonNull Provider<T> provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Router encoder(@NonNull MessageEncoder encoder) {
        this.encoder.add(MediaType.all, encoder);
        return this;
    }

    @Override
    @NonNull
    public Router encoder(@NonNull MediaType contentType, @NonNull MessageEncoder encoder) {
        this.encoder.add(contentType, encoder);
        return this;
    }

    @Override
    @NonNull
    public Router decoder(@NonNull MediaType contentType, @NonNull MessageDecoder decoder) {
        this.decoders.put(contentType.getValue(), decoder);
        return this;
    }

    @Override
    @NonNull
    public Executor getWorker() {
        return this.worker;
    }

    @Override
    @NonNull
    public DataBufferFactory getBufferFactory() {
        if (this.bufferFactory == null) {
            this.bufferFactory = ServiceLoader.load(DataBufferFactory.class).findFirst().orElse(DefaultDataBufferFactory.sharedInstance);
        }
        return this.bufferFactory;
    }

    @Override
    @NonNull
    public Router setBufferFactory(@NonNull DataBufferFactory bufferFactory) {
        this.bufferFactory = bufferFactory;
        return this;
    }

    @Override
    @NonNull
    public Router setWorker(Executor worker) {
        ForwardingExecutor workerRef = (ForwardingExecutor)this.worker;
        workerRef.executor = worker;
        return this;
    }

    @Override
    @NonNull
    public Router setDefaultWorker(@NonNull Executor worker) {
        ForwardingExecutor workerRef = (ForwardingExecutor)this.worker;
        if (workerRef.executor == null) {
            workerRef.executor = worker;
        }
        return this;
    }

    @Override
    @NonNull
    public Router use(@NonNull Route.Filter filter) {
        this.stack.peekLast().then(filter);
        return this;
    }

    @Override
    @NonNull
    public Router after(@NonNull Route.After after) {
        this.stack.peekLast().then(after);
        return this;
    }

    @Override
    @NonNull
    public Router before(@NonNull Route.Before before) {
        this.stack.peekLast().then(before);
        return this;
    }

    @Override
    @NonNull
    public Router error(@NonNull ErrorHandler handler) {
        this.err = this.err == null ? handler : this.err.then(handler);
        return this;
    }

    @Override
    @NonNull
    public Router dispatch(@NonNull Runnable body) {
        return this.newStack(this.push(this.chi).executor(this.worker), body, new Route.Filter[0]);
    }

    @Override
    @NonNull
    public Router dispatch(@NonNull Executor executor, @NonNull Runnable action) {
        return this.newStack(this.push(this.chi).executor(executor), action, new Route.Filter[0]);
    }

    @Override
    @NonNull
    public RouteSet routes(@NonNull Runnable action) {
        return this.path("/", action);
    }

    @Override
    @NonNull
    public RouteSet path(@NonNull String pattern, @NonNull Runnable action) {
        RouteSet routeSet = new RouteSet();
        int start = this.routes.size();
        this.newStack(this.chi, pattern, action, new Route.Filter[0]);
        routeSet.setRoutes(this.routes.subList(start, this.routes.size()));
        return routeSet;
    }

    @Override
    @NonNull
    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Override
    @NonNull
    public Router setSessionStore(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
        return this;
    }

    @Override
    @NonNull
    public Router converter(ValueConverter converter) {
        if (converter instanceof BeanConverter) {
            this.beanConverters.add((BeanConverter)converter);
        } else {
            this.converters.addFirst(converter);
        }
        return this;
    }

    @Override
    @NonNull
    public List<ValueConverter> getConverters() {
        return this.converters;
    }

    @Override
    @NonNull
    public List<BeanConverter> getBeanConverters() {
        return this.beanConverters;
    }

    @Override
    @NonNull
    public Route ws(@NonNull String pattern, @NonNull WebSocket.Initializer handler) {
        return this.route("WS", pattern, new WebSocketHandler(handler)).setHandle(handler);
    }

    @Override
    @NonNull
    public Route sse(@NonNull String pattern, @NonNull ServerSentEmitter.Handler handler) {
        return this.route("SSE", pattern, new ServerSentEventHandler(handler)).setHandle(handler).setExecutorKey("worker");
    }

    @Override
    public Route route(@NonNull String method, @NonNull String pattern, @NonNull Route.Handler handler) {
        return this.newRoute(method, pattern, handler);
    }

    private Route newRoute(@NonNull String method, @NonNull String pattern, @NonNull Route.Handler handler) {
        String finalPattern;
        RouteTree tree = this.stack.getLast().tree;
        PathBuilder pathBuilder = new PathBuilder(new String[0]);
        this.stack.stream().filter(Stack::hasPattern).forEach(it -> pathBuilder.append(it.pattern));
        pathBuilder.append(pattern);
        List decoratorList = this.stack.stream().flatMap(Stack::toFilter).toList();
        Route.Filter decorator = decoratorList.stream().reduce(null, (it, next) -> it == null ? next : it.then((Route.Filter)next));
        Route.After after = this.stack.stream().flatMap(Stack::toAfter).reduce(null, (it, next) -> it == null ? next : it.then((Route.After)next));
        String safePattern = pathBuilder.toString();
        Route route = new Route(method, safePattern, handler);
        route.setPathKeys(Router.pathKeys(safePattern));
        route.setAfter(after);
        route.setFilter(decorator);
        route.setEncoder(this.encoder);
        route.setDecoders(this.decoders);
        decoratorList.forEach(it -> it.setRoute(route));
        handler.setRoute(route);
        Stack stack = this.stack.peekLast();
        if (stack.executor != null) {
            this.routeExecutor.put(route, stack.executor);
        }
        String string = finalPattern = this.basePath == null ? safePattern : new PathBuilder(this.basePath, safePattern).toString();
        if (this.routerOptions.contains((Object)RouterOption.IGNORE_CASE)) {
            finalPattern = finalPattern.toLowerCase();
        }
        this.pureAscii(finalPattern, asciiPattern -> {
            for (String routePattern : Router.expandOptionalVariables(asciiPattern)) {
                if (route.getMethod().equals("WS")) {
                    tree.insert("GET", routePattern, route);
                    route.setReturnType((Type)((Object)Context.class));
                    continue;
                }
                if (route.getMethod().equals("SSE")) {
                    tree.insert("GET", routePattern, route);
                    route.setReturnType((Type)((Object)Context.class));
                    continue;
                }
                tree.insert(route.getMethod(), routePattern, route);
                if (route.isHttpOptions()) {
                    tree.insert("OPTIONS", routePattern, route);
                    continue;
                }
                if (route.isHttpTrace()) {
                    tree.insert("TRACE", routePattern, route);
                    continue;
                }
                if (!route.isHttpHead() || !route.getMethod().equals("GET")) continue;
                tree.insert("HEAD", routePattern, route);
            }
        });
        this.routes.add(route);
        return route;
    }

    private void pureAscii(String pattern, Consumer<String> consumer) {
        consumer.accept(pattern);
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(pattern)) {
            String pureAscii = Stream.of(pattern.split("/")).map(segment -> {
                if (segment.matches(".*\\{([^}]*.?)}.*")) {
                    return segment;
                }
                return XSS.uri(segment);
            }).collect(Collectors.joining("/"));
            consumer.accept(pureAscii);
        }
    }

    @NonNull
    public Router start(@NonNull Jooby app, @NonNull Server server) {
        this.started = true;
        ErrorHandler globalErrHandler = this.defineGlobalErrorHandler(app);
        this.err = this.err == null ? globalErrHandler : this.err.then(globalErrHandler);
        ExecutionMode mode = app.getExecutionMode();
        for (Route route : this.routes) {
            Executor executor;
            String executorKey = route.getExecutorKey();
            if (executorKey == null) {
                executor = this.routeExecutor.get(route);
                if (executor instanceof ForwardingExecutor) {
                    executor = ((ForwardingExecutor)executor).executor;
                }
            } else {
                executor = executorKey.equals("worker") ? (this.worker instanceof ForwardingExecutor ? ((ForwardingExecutor)this.worker).executor : this.worker) : this.executor(executorKey);
            }
            if (route.getHandler() instanceof WebSocketHandler) {
                if (route.getConsumes().isEmpty()) {
                    route.setConsumes(Collections.singletonList(MediaType.json));
                }
                if (route.getProduces().isEmpty()) {
                    route.setProduces(Collections.singletonList(MediaType.json));
                }
            } else {
                route.setFilter(this.prependMediaType(route.getConsumes(), route.getFilter(), Route.SUPPORT_MEDIA_TYPE));
                route.setFilter(this.prependMediaType(route.getProduces(), route.getFilter(), Route.ACCEPT));
            }
            boolean requiresDetach = server.getName().equals("undertow");
            Route.Handler pipeline = Pipeline.build(requiresDetach, route, this.forceMode(route, mode), executor, this.postDispatchInitializer);
            route.setPipeline(pipeline);
            route.setEncoder(this.encoder);
        }
        ((Chi)this.chi).setEncoder(this.encoder);
        if (this.routerOptions.contains((Object)RouterOption.IGNORE_CASE)) {
            this.chi = new RouteTreeLowerCasePath(this.chi);
        }
        if (this.routerOptions.contains((Object)RouterOption.IGNORE_TRAILING_SLASH)) {
            this.chi = new RouteTreeIgnoreTrailingSlash(this.chi);
        }
        if (this.routerOptions.contains((Object)RouterOption.NORMALIZE_SLASH)) {
            this.chi = new RouteTreeNormPath(this.chi);
        }
        this.worker = ((ForwardingExecutor)this.worker).executor;
        this.stack.forEach(Stack::clear);
        this.stack = null;
        this.routeExecutor.clear();
        this.routeExecutor = null;
        return this;
    }

    private ErrorHandler defineGlobalErrorHandler(Jooby app) {
        if (app.problemDetailsIsEnabled()) {
            return ProblemDetailsHandler.from(app.getConfig());
        }
        return ErrorHandler.create();
    }

    private ExecutionMode forceMode(Route route, ExecutionMode mode) {
        if (route.getMethod().equals("WS")) {
            return ExecutionMode.WORKER;
        }
        return mode;
    }

    private Route.Filter prependMediaType(List<MediaType> contentTypes, Route.Filter before, Route.Filter prefix) {
        if (contentTypes.size() > 0) {
            return before == null ? prefix : prefix.then(before);
        }
        return before;
    }

    @Override
    public Logger getLog() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @NonNull
    public Router executor(@NonNull String name, @NonNull Executor executor) {
        this.services.put(ServiceKey.key(Executor.class, name), executor);
        return this;
    }

    public void destroy() {
        this.stopped = true;
        this.routes.clear();
        this.routes = null;
        this.chi.destroy();
        if (this.errorCodes != null) {
            this.errorCodes.clear();
            this.errorCodes = null;
        }
        if (this.predicateMap != null) {
            this.predicateMap.values().forEach(RouteTree::destroy);
            this.predicateMap.clear();
            this.predicateMap = null;
        }
    }

    @Override
    @NonNull
    public ErrorHandler getErrorHandler() {
        return this.err;
    }

    @Override
    @NonNull
    public Router.Match match(@NonNull Context ctx) {
        if (this.preDispatchInitializer != null) {
            this.preDispatchInitializer.apply(ctx);
        }
        if (this.predicateMap != null) {
            for (Map.Entry<Predicate<Context>, RouteTree> e : this.predicateMap.entrySet()) {
                Router.Match match;
                if (!e.getKey().test(ctx) || !(match = e.getValue().find(ctx.getMethod(), ctx.getRequestPath())).matches()) continue;
                return match;
            }
        }
        return this.chi.find(ctx.getMethod(), ctx.getRequestPath());
    }

    @Override
    public boolean match(@NonNull String pattern, @NonNull String path) {
        Chi chi = new Chi();
        chi.insert("GET", pattern, ROUTE_MARK);
        return chi.exists("GET", path);
    }

    @Override
    @NonNull
    public Router errorCode(@NonNull Class<? extends Throwable> type, @NonNull StatusCode statusCode) {
        if (this.errorCodes == null) {
            this.errorCodes = new HashMap<String, StatusCode>();
        }
        this.errorCodes.put(type.getCanonicalName(), statusCode);
        return this;
    }

    @Override
    @NonNull
    public StatusCode errorCode(@NonNull Throwable x) {
        if (x instanceof StatusCodeException) {
            return ((StatusCodeException)x).getStatusCode();
        }
        if (this.errorCodes != null) {
            for (Class<?> type = x.getClass(); type != Throwable.class; type = type.getSuperclass()) {
                StatusCode errorCode = this.errorCodes.get(type.getCanonicalName());
                if (errorCode == null) continue;
                return errorCode;
            }
        }
        if (x instanceof IllegalArgumentException || x instanceof NoSuchElementException) {
            return StatusCode.BAD_REQUEST;
        }
        if (x instanceof FileNotFoundException || x instanceof NoSuchFileException) {
            return StatusCode.NOT_FOUND;
        }
        return StatusCode.SERVER_ERROR;
    }

    @Override
    @NonNull
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    @NonNull
    public <T> T require(@NonNull Class<T> type, @NonNull String name) throws RegistryException {
        return this.services.require(type, name);
    }

    @Override
    @NonNull
    public <T> T require(@NonNull Class<T> type) throws RegistryException {
        return this.services.require(type);
    }

    @Override
    @NonNull
    public <T> T require(@NonNull ServiceKey<T> key) throws RegistryException {
        return this.services.require(key);
    }

    @Override
    @NonNull
    public Cookie getFlashCookie() {
        return this.flashCookie;
    }

    @Override
    @NonNull
    public Router setFlashCookie(@NonNull Cookie flashCookie) {
        this.flashCookie = Objects.requireNonNull(flashCookie);
        return this;
    }

    @Override
    @NonNull
    public ServerOptions getServerOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Router setHiddenMethod(@NonNull String parameterName) {
        this.setHiddenMethod(new DefaultHiddenMethodLookup(parameterName));
        return this;
    }

    @Override
    @NonNull
    public Router setHiddenMethod(@NonNull Function<Context, Optional<String>> provider) {
        this.addPreDispatchInitializer(new HiddenMethodInitializer(provider));
        return this;
    }

    @Override
    @NonNull
    public Router setCurrentUser(@NonNull Function<Context, Object> provider) {
        this.addPreDispatchInitializer(new CurrentUserInitializer(provider));
        return this;
    }

    @Override
    @NonNull
    public Router setContextAsService(boolean contextAsService) {
        if (this.contextAsService == contextAsService) {
            return this;
        }
        this.contextAsService = contextAsService;
        if (contextAsService) {
            this.addPostDispatchInitializer(ContextAsServiceInitializer.INSTANCE);
            this.getServices().put(Context.class, ContextAsServiceInitializer.INSTANCE);
        } else {
            this.removePostDispatchInitializer(ContextAsServiceInitializer.INSTANCE);
            this.getServices().put(Context.class, (Provider)null);
        }
        return this;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.routes != null) {
            int size = IntStream.range(0, this.routes.size()).map(i -> this.routes.get(i).getMethod().length() + 1).max().orElse(0);
            this.routes.forEach(r -> buff.append(String.format("\n  %-" + size + "s", r.getMethod())).append(r.getPattern()));
        }
        return !buff.isEmpty() ? buff.substring(1) : "";
    }

    private Router newStack(RouteTree tree, String pattern, Runnable action, Route.Filter ... filter) {
        return this.newStack(this.push(tree, pattern), action, filter);
    }

    private Stack push(RouteTree tree) {
        return new Stack(tree, null);
    }

    private Stack push(RouteTree tree, String pattern) {
        Stack stack = new Stack(tree, Router.leadingSlash(pattern));
        if (!this.stack.isEmpty()) {
            Stack parent = this.stack.getLast();
            stack.executor = parent.executor;
        }
        return stack;
    }

    private Router newStack(@NonNull Stack stack, @NonNull Runnable action, Route.Filter ... filter) {
        Stream.of(filter).forEach(stack::then);
        this.stack.addLast(stack);
        action.run();
        this.stack.removeLast().clear();
        return this;
    }

    private void copy(Route src, Route it) {
        Route.Filter filter = Optional.ofNullable(it.getFilter()).map(e -> Optional.ofNullable(src.getFilter()).map(e::then).orElse((Route.Filter)e)).orElseGet(src::getFilter);
        Route.After after = Optional.ofNullable(it.getAfter()).map(e -> Optional.ofNullable(src.getAfter()).map(e::then).orElse((Route.After)e)).orElseGet(src::getAfter);
        it.setPathKeys(src.getPathKeys());
        it.setFilter(filter);
        it.setAfter(after);
        it.setEncoder(src.getEncoder());
        it.setReturnType(src.getReturnType());
        it.setHandle(src.getHandle());
        it.setProduces(src.getProduces());
        it.setConsumes(src.getConsumes());
        it.setAttributes(src.getAttributes());
        it.setExecutorKey(src.getExecutorKey());
        it.setTags(src.getTags());
        it.setDescription(src.getDescription());
        it.setMvcMethod(src.getMvcMethod());
        it.setNonBlocking(src.isNonBlocking());
        it.setSummary(src.getSummary());
    }

    private void putPredicate(@NonNull Predicate<Context> predicate, Chi tree) {
        if (this.predicateMap == null) {
            this.predicateMap = new LinkedHashMap<Predicate<Context>, RouteTree>();
        }
        this.predicateMap.put(predicate, tree);
    }

    private void removePreDispatchInitializer(ContextInitializer initializer) {
        if (this.preDispatchInitializer instanceof ContextInitializerList) {
            ((ContextInitializerList)initializer).remove(initializer);
        } else if (this.preDispatchInitializer == initializer) {
            this.preDispatchInitializer = null;
        }
    }

    private void addPreDispatchInitializer(ContextInitializer initializer) {
        if (this.preDispatchInitializer instanceof ContextInitializerList) {
            this.preDispatchInitializer.add(initializer);
        } else {
            this.preDispatchInitializer = this.preDispatchInitializer != null ? new ContextInitializerList(this.preDispatchInitializer).add(initializer) : initializer;
        }
    }

    private void removePostDispatchInitializer(ContextInitializer initializer) {
        if (this.postDispatchInitializer instanceof ContextInitializerList) {
            ((ContextInitializerList)this.postDispatchInitializer).remove(initializer);
        } else if (this.postDispatchInitializer == initializer) {
            this.postDispatchInitializer = null;
        }
    }

    private void addPostDispatchInitializer(ContextInitializer initializer) {
        if (this.postDispatchInitializer instanceof ContextInitializerList) {
            this.postDispatchInitializer.add(initializer);
        } else {
            this.postDispatchInitializer = this.postDispatchInitializer != null ? new ContextInitializerList(this.postDispatchInitializer).add(initializer) : initializer;
        }
    }

    private static Predicate<Context> domainPredicate(String domain) {
        return ctx -> ctx.getHost().equals(domain);
    }

    private void copyRoutes(@NonNull String path, @NonNull Router router) {
        String prefix = Router.leadingSlash(path);
        for (Route route : router.getRoutes()) {
            String routePattern = new PathBuilder(prefix, route.getPattern()).toString();
            Route newRoute = this.newRoute(route.getMethod(), routePattern, route.getHandler());
            this.copy(route, newRoute);
            newRoute.setPathKeys(Router.pathKeys(routePattern));
        }
    }

    private static void override(RouterImpl src, Router router, BiConsumer<RouterImpl, RouterImpl> consumer) {
        if (router instanceof Jooby) {
            Jooby app = (Jooby)router;
            RouterImpl.override(src, app.getRouter(), consumer);
        } else if (router instanceof RouterImpl) {
            RouterImpl that = (RouterImpl)router;
            consumer.accept(src, that);
        }
    }

    private void overrideAll(RouterImpl src, Router router) {
        RouterImpl.override(src, router, (self, that) -> {
            that.services = self.services;
        });
        RouterImpl.override(src, router, (self, that) -> {
            that.worker = self.worker;
        });
        RouterImpl.override(src, router, (self, that) -> that.attributes.putAll(self.attributes));
    }

    private void mergeErrorHandler(Router router) {
        if (router instanceof Jooby) {
            Jooby app = (Jooby)router;
            this.mergeErrorHandler(app.getRouter());
        } else if (router instanceof RouterImpl) {
            RouterImpl that = (RouterImpl)router;
            if (that.err != null) {
                this.error(that.err);
            }
        }
    }

    private static class Stack {
        private RouteTree tree;
        private String pattern;
        private Executor executor;
        private List<Route.Filter> decoratorList = new ArrayList<Route.Filter>();
        private List<Route.After> afterList = new ArrayList<Route.After>();

        public Stack(RouteTree tree, String pattern) {
            this.tree = tree;
            this.pattern = pattern;
        }

        public void then(Route.Filter filter) {
            this.decoratorList.add(filter);
        }

        public void then(Route.After after) {
            this.afterList.add(after);
        }

        public void then(Route.Before before) {
            this.decoratorList.add(before);
        }

        public Stream<Route.Filter> toFilter() {
            return this.decoratorList.stream();
        }

        public Stream<Route.After> toAfter() {
            return this.afterList.stream();
        }

        public boolean hasPattern() {
            return this.pattern != null;
        }

        public void clear() {
            this.decoratorList.clear();
            this.afterList.clear();
            this.executor = null;
        }

        public Stack executor(Executor executor) {
            this.executor = executor;
            return this;
        }
    }

    private static class PathBuilder {
        private StringBuilder buffer;

        public PathBuilder(String ... path) {
            Stream.of(path).forEach(this::append);
        }

        public PathBuilder append(String path) {
            if (!path.equals("/")) {
                if (this.buffer == null) {
                    this.buffer = new StringBuilder();
                }
                this.buffer.append(path);
            }
            return this;
        }

        public String toString() {
            return this.buffer == null ? "/" : this.buffer.toString();
        }
    }
}

