/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.MessageEncoder;
import io.jooby.Route;
import io.jooby.Router;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RouterMatch
implements Router.Match {
    boolean matches;
    private Route route;
    Map vars = Collections.EMPTY_MAP;
    private Route.Handler handler;

    public void key(List<String> keys2) {
        for (int i = 0; i < Math.min(keys2.size(), this.vars.size()); ++i) {
            this.vars.put(keys2.get(i), this.vars.remove(i));
        }
    }

    public void truncate(int size) {
        while (size < this.vars.size()) {
            this.vars.remove(size++);
        }
    }

    public void value(String value) {
        if (this.vars == Collections.EMPTY_MAP) {
            this.vars = new LinkedHashMap();
        }
        this.vars.put(this.vars.size(), value);
    }

    public void pop() {
        this.vars.remove(this.vars.size() - 1);
    }

    public void methodNotAllowed(Set<String> allow) {
        String allowString = String.join((CharSequence)",", allow);
        Route.Filter filter = next -> ctx -> {
            ctx.setResponseHeader("Allow", allowString);
            return next.apply(ctx);
        };
        this.handler = filter.then(Route.METHOD_NOT_ALLOWED);
    }

    @Override
    public boolean matches() {
        return this.matches;
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public Map<String, String> pathMap() {
        return this.vars;
    }

    public RouterMatch found(Route route) {
        this.route = route;
        this.matches = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(@NonNull Context context, @NonNull Route.Handler pipeline) {
        context.setPathMap(this.vars);
        context.setRoute(this.route);
        try {
            Object object = pipeline.apply(context);
            return object;
        }
        catch (Throwable x) {
            context.sendError(x);
            Throwable throwable = x;
            return throwable;
        }
        finally {
            this.handler = null;
            this.route = null;
            this.vars = null;
        }
    }

    public RouterMatch missing(String method, String path, MessageEncoder encoder) {
        Route.Handler h = this.handler == null ? (path.endsWith("/favicon.ico") ? Route.FAVICON : Route.NOT_FOUND) : this.handler;
        this.route = new Route(method, path, h);
        this.route.setEncoder(encoder);
        this.route.setReturnType((Type)((Object)Context.class));
        return this;
    }
}

