/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private final Map<ServiceKey<?>, Provider<?>> registry = new ConcurrentHashMap();

    @Override
    @NonNull
    public Set<ServiceKey<?>> keySet() {
        return this.registry.keySet();
    }

    @Override
    @NonNull
    public Set<Map.Entry<ServiceKey<?>, Provider<?>>> entrySet() {
        return this.registry.entrySet();
    }

    @Override
    @Nullable
    public <T> T getOrNull(@NonNull ServiceKey<T> key) {
        Provider<?> provider = this.registry.get(key);
        if (provider == null) {
            return null;
        }
        return (T)provider.get();
    }

    @Override
    @Nullable
    public <T> T put(@NonNull ServiceKey<T> key, T service) {
        return this.put(key, ServiceRegistryImpl.singleton(service));
    }

    @Override
    @Nullable
    public <T> T put(@NonNull ServiceKey<T> key, Provider<T> service) {
        return (T)this.registry.put(key, service);
    }

    @Override
    @Nullable
    public <T> T putIfAbsent(@NonNull ServiceKey<T> type, T service) {
        return this.putIfAbsent(type, ServiceRegistryImpl.singleton(service));
    }

    @Override
    @Nullable
    public <T> T putIfAbsent(@NonNull ServiceKey<T> key, Provider<T> service) {
        return (T)this.registry.putIfAbsent(key, service);
    }

    private static <T> Provider<T> singleton(T service) {
        return () -> service;
    }
}

