/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.Value;
import io.jooby.ValueNode;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionImpl
implements Session {
    private Context ctx;
    private boolean isNew;
    private String id;
    private Map<String, String> attributes;
    private Instant creationTime;
    private Instant lastAccessedTime;
    private boolean modify;

    public SessionImpl(Context ctx, String id) {
        this(ctx, id, new ConcurrentHashMap<String, String>());
    }

    public SessionImpl(Context ctx, String id, Map<String, String> attributes) {
        this.ctx = ctx;
        this.id = id;
        this.attributes = attributes;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    @NonNull
    public Session setNew(boolean aNew) {
        this.isNew = aNew;
        return this;
    }

    @Override
    public boolean isModify() {
        return this.modify;
    }

    @Override
    @NonNull
    public Session setModify(boolean modify) {
        this.modify = modify;
        return this;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @NonNull
    public Session setId(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Override
    @NonNull
    public Value get(@NonNull String name) {
        return Value.create(this.ctx, name, this.attributes.get(name));
    }

    @Override
    @NonNull
    public Session put(@NonNull String name, String value) {
        this.attributes.put(name, value);
        this.updateState();
        return this;
    }

    @Override
    @NonNull
    public ValueNode remove(@NonNull String name) {
        String value = this.attributes.remove(name);
        this.updateState();
        return value == null ? Value.missing(name) : Value.value(this.ctx, name, value);
    }

    @Override
    @NonNull
    public Map<String, String> toMap() {
        return this.attributes;
    }

    @Override
    @NonNull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    @NonNull
    public Session setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Override
    @NonNull
    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    @NonNull
    public Session setLastAccessedTime(@NonNull Instant lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    @Override
    public Session clear() {
        this.attributes.clear();
        this.updateState();
        return this;
    }

    @Override
    public void destroy() {
        this.ctx.getAttributes().remove("session");
        this.attributes.clear();
        SessionImpl.store(this.ctx).deleteSession(this.ctx, this);
    }

    @Override
    public Session renewId() {
        SessionImpl.store(this.ctx).renewSessionId(this.ctx, this);
        this.updateState();
        return this;
    }

    private void updateState() {
        this.modify = true;
        this.lastAccessedTime = Instant.now();
        SessionImpl.store(this.ctx).touchSession(this.ctx, this);
    }

    private static SessionStore store(Context ctx) {
        return ctx.getRouter().getSessionStore();
    }
}

