/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SessionToken;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class SignedSessionStore
implements SessionStore {
    private final Function<String, Map<String, String>> decoder;
    private final Function<Map<String, String>, String> encoder;
    private final SessionToken token;

    public SignedSessionStore(SessionToken token, Function<String, Map<String, String>> decoder, Function<Map<String, String>, String> encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
        this.token = token;
    }

    @Override
    @NonNull
    public Session newSession(@NonNull Context ctx) {
        return Session.create(ctx, null).setNew(true);
    }

    @Override
    @Nullable
    public Session findSession(@NonNull Context ctx) {
        String signed = this.token.findToken(ctx);
        if (signed == null) {
            return null;
        }
        Map<String, String> attributes = this.decoder.apply(signed);
        if (attributes == null || attributes.size() == 0) {
            return null;
        }
        return Session.create(ctx, signed, new HashMap<String, String>(attributes)).setNew(false);
    }

    @Override
    public void deleteSession(@NonNull Context ctx, @NonNull Session session) {
        this.token.deleteToken(ctx, null);
    }

    @Override
    public void touchSession(@NonNull Context ctx, @NonNull Session session) {
        this.token.saveToken(ctx, this.encoder.apply(session.toMap()));
    }

    @Override
    public void saveSession(@NonNull Context ctx, @NonNull Session session) {
    }

    @Override
    public void renewSessionId(@NonNull Context ctx, @NonNull Session session) {
        this.token.saveToken(ctx, this.encoder.apply(session.toMap()));
    }
}

