/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.ByteRange;
import io.jooby.Context;
import io.jooby.StatusCode;
import io.jooby.internal.IOUtils;
import java.io.IOException;
import java.io.InputStream;

public class SingleByteRange
implements ByteRange {
    private String value;
    private long start;
    private long end;
    private long contentLength;
    private String contentRange;

    public SingleByteRange(String value, long start, long end, long contentLength, String contentRange) {
        this.value = value;
        this.start = start;
        this.end = end;
        this.contentLength = contentLength;
        this.contentRange = contentRange;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @NonNull
    public String getContentRange() {
        return this.contentRange;
    }

    @Override
    @NonNull
    public StatusCode getStatusCode() {
        return StatusCode.PARTIAL_CONTENT;
    }

    @Override
    @NonNull
    public ByteRange apply(@NonNull Context ctx) {
        ctx.setResponseHeader("Accept-Ranges", "bytes");
        ctx.setResponseHeader("Content-Range", this.contentRange);
        ctx.setResponseLength(this.contentLength);
        ctx.setResponseCode(StatusCode.PARTIAL_CONTENT);
        return this;
    }

    @Override
    @NonNull
    public InputStream apply(@NonNull InputStream input) throws IOException {
        return IOUtils.bounded(input, this.start, this.end);
    }

    public String toString() {
        return this.value;
    }
}

