/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.internal.SslContextProvider;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslPkcs12Provider
implements SslContextProvider {
    @Override
    public boolean supports(String type) {
        return "PKCS12".equalsIgnoreCase(type);
    }

    @Override
    public SSLContext create(ClassLoader loader, String provider, SslOptions options) {
        SslOptions sslOptions = options;
        try {
            TrustManager[] tms;
            SSLContext context;
            KeyStore store = this.keystore(options, options.getCert(), options.getPassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(store, this.toCharArray(options.getPassword()));
            KeyManager[] kms = kmf.getKeyManagers();
            SSLContext sSLContext = context = provider == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", provider);
            if (options.getTrustCert() != null) {
                KeyStore trustStore = this.keystore(options, options.getTrustCert(), options.getTrustPassword());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                tms = null;
            }
            context.init(kms, tms, null);
            SSLContext sSLContext2 = context;
            if (sslOptions != null) {
                sslOptions.close();
            }
            return sSLContext2;
        }
        catch (Throwable throwable) {
            try {
                if (sslOptions != null) {
                    try {
                        sslOptions.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception x) {
                throw SneakyThrows.propagate(x);
            }
        }
    }

    private KeyStore keystore(SslOptions options, InputStream resource, String password) throws Exception {
        KeyStore store = KeyStore.getInstance(options.getType());
        store.load(resource, this.toCharArray(password));
        return store;
    }

    private char[] toCharArray(String password) {
        return password == null ? null : password.toCharArray();
    }
}

