/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import io.jooby.Context;
import io.jooby.QueryString;
import io.jooby.SneakyThrows;
import io.jooby.internal.HashValue;
import io.jooby.internal.QueryStringValue;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public final class UrlParser {
    private static final char SPACE = ' ';

    public static QueryString queryString(Context ctx, String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return new QueryStringValue(ctx, "");
        }
        QueryStringValue result = new QueryStringValue(ctx, "?" + queryString);
        UrlParser.decodeParams(result, queryString, 0, StandardCharsets.UTF_8, 1024);
        return result;
    }

    public static String decodePathSegment(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        return UrlParser.decodeComponent(value, 0, value.length(), StandardCharsets.UTF_8, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void decodeParams(HashValue root, String s, int from, Charset charset, int paramsLimit) {
        int i;
        int len = s.length();
        if (from >= len) {
            return;
        }
        if (s.charAt(from) == '?') {
            ++from;
        }
        int nameStart = from;
        int valueStart = -1;
        block5: for (i = from; i < len; ++i) {
            switch (s.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (UrlParser.addParam(root, s, nameStart, valueStart, i, charset) && --paramsLimit == 0) {
                        return;
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        UrlParser.addParam(root, s, nameStart, valueStart, i, charset);
    }

    private static boolean addParam(HashValue root, String s, int nameStart, int valueStart, int valueEnd, Charset charset) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = UrlParser.decodeComponent(s, nameStart, valueStart - 1, charset, false);
        String value = UrlParser.decodeComponent(s, valueStart, valueEnd, charset, false);
        root.put(name, value);
        return true;
    }

    private static String decodeComponent(String s, int from, int toExcluded, Charset charset, boolean isPath) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        CharsetDecoder decoder = charset.newDecoder();
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        ByteBuffer byteBuf = ByteBuffer.allocate(decodedCapacity);
        CharBuffer charBuf = CharBuffer.allocate(decodedCapacity);
        StringBuilder strBuf = new StringBuilder(len);
        strBuf.append(s, from, firstEscaped);
        for (int i = firstEscaped; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                strBuf.append(c != '+' || isPath ? c : (char)' ');
                continue;
            }
            byteBuf.clear();
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + s);
                }
                byteBuf.put(UrlParser.decodeHexByte(s, i + 1));
            } while ((i += 3) < toExcluded && s.charAt(i) == '%');
            --i;
            byteBuf.flip();
            charBuf.clear();
            CoderResult result = decoder.reset().decode(byteBuf, charBuf, true);
            try {
                if (!result.isUnderflow()) {
                    result.throwException();
                }
                if (!(result = decoder.flush(charBuf)).isUnderflow()) {
                    result.throwException();
                }
            }
            catch (CharacterCodingException ex) {
                throw SneakyThrows.propagate(ex);
            }
            strBuf.append(charBuf.flip());
        }
        return strBuf.toString();
    }

    private static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private static byte decodeHexByte(CharSequence s, int pos) {
        int hi = UrlParser.decodeHexNibble(s.charAt(pos));
        int lo = UrlParser.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }
}

