/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.ForwardingContext;
import io.jooby.MediaType;
import io.jooby.StatusCode;
import io.jooby.WebSocket;
import io.jooby.buffer.DataBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Date;

public class WebSocketSender
extends ForwardingContext
implements DefaultContext {
    private final WebSocket ws;
    private final boolean binary;
    private final WebSocket.WriteCallback callback;

    public WebSocketSender(@NonNull Context context, @NonNull WebSocket ws, boolean binary, WebSocket.WriteCallback callback) {
        super(context);
        this.ws = ws;
        this.binary = binary;
        this.callback = callback;
    }

    @Override
    @NonNull
    public Context send(@NonNull String data, @NonNull Charset charset) {
        if (this.binary) {
            this.ws.sendBinary(data.getBytes(charset), this.callback);
        } else {
            this.ws.send(data.getBytes(charset), this.callback);
        }
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull byte[] data) {
        if (this.binary) {
            this.ws.sendBinary(data, this.callback);
        } else {
            this.ws.send(data, this.callback);
        }
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull ByteBuffer data) {
        if (this.binary) {
            this.ws.sendBinary(data, this.callback);
        } else {
            this.ws.send(data, this.callback);
        }
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull DataBuffer data) {
        if (this.binary) {
            this.ws.sendBinary(data, this.callback);
        } else {
            this.ws.send(data, this.callback);
        }
        return this;
    }

    @Override
    @NonNull
    public Context render(@NonNull Object value) {
        DefaultContext.super.render(value);
        return this;
    }

    @Override
    public Context setResetHeadersOnError(boolean value) {
        return this;
    }

    @Override
    @NonNull
    public Context setDefaultResponseType(@NonNull MediaType contentType) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseCode(int statusCode) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseCode(@NonNull StatusCode statusCode) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseCookie(@NonNull Cookie cookie) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseHeader(@NonNull String name, @NonNull String value) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseHeader(@NonNull String name, @NonNull Date value) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseHeader(@NonNull String name, @NonNull Object value) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseHeader(@NonNull String name, @NonNull Instant value) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseLength(long length) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseType(@NonNull String contentType) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseType(@NonNull MediaType contentType, @Nullable Charset charset) {
        return this;
    }

    @Override
    @NonNull
    public Context setResponseType(@NonNull MediaType contentType) {
        return this;
    }
}

