/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.handler;

import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.MessageEncoder;
import io.jooby.Route;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.buffer.DataBuffer;
import java.util.concurrent.Flow;
import org.slf4j.Logger;

public class ChunkedSubscriber
implements Flow.Subscriber {
    private static final byte JSON_LBRACKET = 91;
    private static final byte JSON_SEP = 44;
    private static final byte[] JSON_RBRACKET = new byte[]{93};
    private Flow.Subscription subscription;
    private Context ctx;
    private Sender sender;
    private MediaType responseType;

    public ChunkedSubscriber(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        this.subscription.request(1L);
    }

    public void onNext(Object item) {
        try {
            Route route = this.ctx.getRoute();
            Route.After after = route.getAfter();
            if (after != null) {
                after.apply(this.ctx, item, null);
            }
            MessageEncoder encoder = route.getEncoder();
            DataBuffer data = encoder.encode(this.ctx, item);
            if (this.responseType == null) {
                this.responseType = this.ctx.getResponseType();
                if (this.responseType.isJson()) {
                    data = ChunkedSubscriber.prepend(this.ctx, data, (byte)91);
                }
            } else if (this.responseType.isJson()) {
                data = ChunkedSubscriber.prepend(this.ctx, data, (byte)44);
            }
            this.sender().write(data, (context, x) -> {
                if (x == null) {
                    this.subscription.request(1L);
                } else {
                    this.onError(x, true);
                }
            });
        }
        catch (Exception x2) {
            this.onError(x2, true);
        }
    }

    @Override
    public void onError(Throwable x) {
        this.onError(x, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable x, boolean cancel) {
        this.responseType = null;
        try {
            Route.After after = this.ctx.getRoute().getAfter();
            if (after != null) {
                try {
                    after.apply(this.ctx, null, x);
                }
                catch (Exception unexpected) {
                    x.addSuppressed(unexpected);
                }
            }
            Logger log = this.ctx.getRouter().getLog();
            if (Server.connectionLost(x)) {
                log.debug("connection lost: {} {}", this.ctx.getMethod(), this.ctx.getRequestPath(), x);
            } else {
                this.ctx.sendError(x);
            }
        }
        finally {
            if (cancel) {
                this.subscription.cancel();
            }
        }
    }

    @Override
    public void onComplete() {
        if (this.responseType != null && this.responseType.isJson()) {
            this.responseType = null;
            this.sender().write(JSON_RBRACKET, (ctx, x) -> {
                if (x != null) {
                    this.onError(x);
                }
            });
        }
        this.sender().close();
    }

    private static DataBuffer prepend(Context ctx, DataBuffer data, byte c) {
        DataBuffer buffer = ctx.getBufferFactory().allocateBuffer();
        buffer.write(c);
        buffer.write(data);
        return buffer;
    }

    private Sender sender() {
        if (this.sender == null) {
            this.sender = this.ctx.responseSender();
        }
        return this.sender;
    }
}

