/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.ReactiveSupport;
import io.jooby.Route;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;

public class ConcurrentHandler
implements Route.Filter {
    @Override
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return ctx -> {
            Object result = next.apply(ctx);
            if (ctx.isResponseStarted()) {
                return ctx;
            }
            if (result instanceof Flow.Publisher) {
                Flow.Publisher publisher = (Flow.Publisher)result;
                publisher.subscribe(ReactiveSupport.newSubscriber(ctx));
                return ctx;
            }
            if (result instanceof CompletionStage) {
                CompletionStage future = (CompletionStage)result;
                future.whenComplete((value, x) -> {
                    try {
                        Route.After after = ctx.getRoute().getAfter();
                        if (after != null) {
                            after.apply(ctx, value, this.unwrap((Throwable)x));
                        }
                        if (x != null) {
                            Throwable exception = this.unwrap((Throwable)x);
                            ctx.sendError(exception);
                        } else if (!ctx.isResponseStarted() && value != ctx) {
                            ctx.render(value);
                        }
                    }
                    catch (Throwable cause) {
                        ctx.sendError(cause);
                    }
                });
                return ctx;
            }
            return result;
        };
    }

    private Throwable unwrap(Throwable x) {
        if (x instanceof CompletionException) {
            return Optional.ofNullable(x.getCause()).orElse(x);
        }
        return x;
    }

    @Override
    public void setRoute(Route route) {
        route.setNonBlocking(true);
    }

    public String toString() {
        return "concurrent";
    }
}

