/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.unbescape.html;

import io.jooby.internal.unbescape.html.HtmlEscapeLevel;
import io.jooby.internal.unbescape.html.HtmlEscapeSymbols;
import io.jooby.internal.unbescape.html.HtmlEscapeType;

public final class HtmlEscapeUtil {
    private static final char[] REFERENCE_DECIMAL_PREFIX = "&#".toCharArray();
    private static final char[] REFERENCE_HEXA_PREFIX = "&#x".toCharArray();
    private static final char REFERENCE_SUFFIX = ';';

    private HtmlEscapeUtil() {
    }

    public static String escape(String text, HtmlEscapeType escapeType, HtmlEscapeLevel escapeLevel) {
        if (text == null) {
            return null;
        }
        int level = escapeLevel.getEscapeLevel();
        boolean useNCRs = escapeType.getUseNCRs();
        boolean useHexa = escapeType.getUseHexa();
        HtmlEscapeSymbols symbols = HtmlEscapeSymbols.HTML5_SYMBOLS;
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max = text.length();
        int readOffset = 0;
        for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            if (c <= '\u007f' && level < symbols.ESCAPE_LEVELS[c] || c > '\u007f' && level < symbols.ESCAPE_LEVELS[128]) continue;
            int codepoint = Character.codePointAt(text, i);
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 20);
            }
            if (i - readOffset > 0) {
                strBuilder.append(text, readOffset, i);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i;
            }
            readOffset = i + 1;
            if (useNCRs) {
                Short ncrIndex;
                if (codepoint < 12287) {
                    short ncrIndex2 = symbols.NCRS_BY_CODEPOINT[codepoint];
                    if (ncrIndex2 != 0) {
                        strBuilder.append(symbols.SORTED_NCRS[ncrIndex2]);
                        continue;
                    }
                } else if (symbols.NCRS_BY_CODEPOINT_OVERFLOW != null && (ncrIndex = symbols.NCRS_BY_CODEPOINT_OVERFLOW.get(codepoint)) != null) {
                    strBuilder.append(symbols.SORTED_NCRS[ncrIndex]);
                    continue;
                }
            }
            if (useHexa) {
                strBuilder.append(REFERENCE_HEXA_PREFIX);
                strBuilder.append(Integer.toHexString(codepoint));
            } else {
                strBuilder.append(REFERENCE_DECIMAL_PREFIX);
                strBuilder.append(codepoint);
            }
            strBuilder.append(';');
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        return strBuilder.toString();
    }
}

