/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.unbescape.uri;

import java.io.UnsupportedEncodingException;

public final class UriEscapeUtil {
    private static final char ESCAPE_PREFIX = '%';
    private static char[] HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();

    private UriEscapeUtil() {
    }

    static char[] printHexa(byte b) {
        char[] result = new char[]{HEXA_CHARS_UPPER[b >> 4 & 0xF], HEXA_CHARS_UPPER[b & 0xF]};
        return result;
    }

    public static String escape(String text, UriEscapeType escapeType, String encoding) {
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max = text.length();
        int readOffset = 0;
        for (int i = 0; i < max; ++i) {
            byte[] charAsBytes;
            int codepoint = Character.codePointAt(text, i);
            if (UriEscapeType.isAlpha(codepoint) || escapeType.isAllowed(codepoint)) continue;
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 20);
            }
            if (i - readOffset > 0) {
                strBuilder.append(text, readOffset, i);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i;
            }
            readOffset = i + 1;
            try {
                charAsBytes = new String(Character.toChars(codepoint)).getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e);
            }
            for (byte b : charAsBytes) {
                strBuilder.append('%');
                strBuilder.append(UriEscapeUtil.printHexa(b));
            }
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        return strBuilder.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum UriEscapeType {
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return UriEscapeType.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return UriEscapeType.isPchar(c);
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 38 == c || 43 == c || 35 == c) {
                    return false;
                }
                return UriEscapeType.isPchar(c) || 47 == c || 63 == c;
            }

            @Override
            public boolean canPlusEscapeWhitespace() {
                return true;
            }
        }
        ,
        FRAGMENT_ID{

            @Override
            public boolean isAllowed(int c) {
                return UriEscapeType.isPchar(c) || 47 == c || 63 == c;
            }
        };


        public abstract boolean isAllowed(int var1);

        public boolean canPlusEscapeWhitespace() {
            return false;
        }

        private static boolean isPchar(int c) {
            return UriEscapeType.isUnreserved(c) || UriEscapeType.isSubDelim(c) || 58 == c || 64 == c;
        }

        private static boolean isUnreserved(int c) {
            return UriEscapeType.isAlpha(c) || UriEscapeType.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        private static boolean isReserved(int c) {
            return UriEscapeType.isGenDelim(c) || UriEscapeType.isSubDelim(c);
        }

        private static boolean isSubDelim(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        private static boolean isGenDelim(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        static boolean isAlpha(int c) {
            return c >= 65 && c <= 90 || c >= 97 && c <= 122;
        }

        private static boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }
    }
}

