/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.problem;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.DefaultErrorHandler;
import io.jooby.ErrorHandler;
import io.jooby.MediaType;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.exception.NotAcceptableException;
import io.jooby.problem.HttpProblem;
import io.jooby.problem.HttpProblemMappable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ProblemDetailsHandler
extends DefaultErrorHandler {
    private static final String MUTE_CODES_KEY = "muteCodes";
    private static final String MUTE_TYPES_KEY = "muteTypes";
    private static final String LOG_4XX_ERRORS_KEY = "log4xxErrors";
    public static final String ROOT_CONFIG_PATH = "problem.details";
    public static final String ENABLED_KEY = "problem.details.enabled";
    private boolean log4xxErrors;

    public ProblemDetailsHandler log4xxErrors() {
        this.log4xxErrors = true;
        return this;
    }

    @Override
    public void apply(@NonNull Context ctx, @NonNull Throwable cause, @NonNull StatusCode code) {
        Logger log = ctx.getRouter().getLog();
        if (cause instanceof NotAcceptableException) {
            NotAcceptableException ex = (NotAcceptableException)cause;
            HttpProblem problem = ex.toHttpProblem();
            this.logProblem(ctx, problem, cause);
            this.sendHtml(ctx, problem);
            return;
        }
        try {
            HttpProblem problem = this.evaluateTheProblem(cause, code);
            this.logProblem(ctx, problem, cause);
            MediaType type = ctx.accept(List.of(ctx.getRequestType(MediaType.text), MediaType.html, MediaType.text, MediaType.json, MediaType.xml));
            ctx.setResponseCode(problem.getStatus());
            problem.getHeaders().forEach(ctx::setResponseHeader);
            if (MediaType.text.equals(type)) {
                ctx.setResponseType(MediaType.text).send(problem.toString());
            } else if (MediaType.html.equals(type)) {
                this.sendHtml(ctx, problem);
            } else {
                try {
                    this.setResponseType(ctx, type);
                    ctx.render(this.toProblemResponse(problem));
                }
                catch (NotAcceptableException ex) {
                    this.sendHtml(ctx, problem);
                }
            }
        }
        catch (Exception ex) {
            log.error("Unexpected error during ProblemDetailsErrorHandler execution", ex);
        }
    }

    private void setResponseType(Context ctx, MediaType type) {
        if (MediaType.json.equals(type)) {
            ctx.setResponseType("application/problem+json");
        } else if (MediaType.xml.equals(type)) {
            ctx.setResponseType("application/problem+xml");
        }
    }

    private HttpProblem evaluateTheProblem(Throwable cause, StatusCode statusCode) {
        HttpProblem problem;
        if (cause instanceof HttpProblem) {
            HttpProblem httpProblem;
            problem = httpProblem = (HttpProblem)cause;
        } else if (cause instanceof HttpProblemMappable) {
            HttpProblemMappable problemMappable = (HttpProblemMappable)((Object)cause);
            problem = problemMappable.toHttpProblem();
        } else {
            int code = statusCode.value();
            if (code == 500) {
                problem = HttpProblem.internalServerError();
            } else if (code > 500) {
                problem = HttpProblem.valueOf(statusCode, statusCode.reason());
            } else {
                String message = cause.getMessage();
                if (message != null) {
                    String details = message.split("\n")[0];
                    problem = HttpProblem.valueOf(statusCode, statusCode.reason(), details);
                } else {
                    problem = HttpProblem.valueOf(statusCode, statusCode.reason());
                }
            }
        }
        return problem;
    }

    private void sendHtml(Context ctx, HttpProblem problem) {
        String title = problem.getTitle();
        StringBuilder html = new StringBuilder("<!doctype html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n<style>\nbody {font-family: \"open sans\",sans-serif; margin-left: 20px;}\nh1 {font-weight: 300; line-height: 44px; margin: 25px 0 0 0;}\nh2 {font-size: 16px;font-weight: 300; line-height: 44px; margin: 0;}\nfooter {font-weight: 300; line-height: 44px; margin-top: 10px;}\nhr {background-color: #f7f7f9;}\ndiv.trace {border:1px solid #e1e1e8; background-color: #f7f7f9;}\np {padding-left: 20px;}\np.tab {padding-left: 40px;}\n</style>\n").append("<title>").append(problem.getStatus()).append("</title>\n").append("<body>\n").append("<h1>").append(title).append("</h1>\n").append("<hr>\n").append("<h2>timestamp: ").append(problem.getTimestamp()).append("</h2>\n").append("<h2>type: ").append(problem.getType()).append("</h2>\n").append("<h2>title: ").append(title).append("</h2>\n").append("<h2>status: ").append(problem.getStatus()).append("</h2>\n");
        if (problem.getInstance() != null) {
            html.append("<h2>instance: ").append(problem.getInstance()).append("</h2>\n");
        }
        if (problem.getDetail() != null) {
            html.append("<h2>detail: ").append(problem.getDetail()).append("</h2>\n");
        }
        if (problem.hasParameters()) {
            html.append("<h2>parameters: ").append(problem.getParameters()).append("</h2>\n");
        }
        if (problem.hasErrors()) {
            html.append("<h2>errors: ").append(problem.getErrors()).append("</h2>\n");
        }
        html.append("</body>\n").append("</html>");
        ctx.setResponseType(MediaType.html).setResponseCode(problem.getStatus()).send(html.toString());
    }

    private Map<String, Object> toProblemResponse(HttpProblem httpProblem) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("timestamp", httpProblem.getTimestamp());
        response.put("type", httpProblem.getType());
        response.put("title", httpProblem.getTitle());
        response.put("status", httpProblem.getStatus());
        response.put("detail", httpProblem.getDetail());
        response.put("instance", httpProblem.getInstance());
        if (httpProblem.hasParameters()) {
            response.put("parameters", httpProblem.getParameters());
        }
        if (httpProblem.hasErrors()) {
            response.put("errors", httpProblem.getErrors());
        }
        return response;
    }

    private void logProblem(Context ctx, HttpProblem problem, Throwable cause) {
        StatusCode statusCode = StatusCode.valueOf(problem.getStatus());
        Logger log = ctx.getRouter().getLog();
        if (problem.getStatus() >= 500) {
            String msg = this.buildLogMsg(ctx, problem, statusCode);
            log.error(msg, cause);
        } else if (!this.isMuted(cause, statusCode) && this.log4xxErrors) {
            String msg = this.buildLogMsg(ctx, problem, statusCode);
            if (log.isDebugEnabled()) {
                log.debug(msg, cause);
            } else {
                log.info(msg);
            }
        }
    }

    private String buildLogMsg(Context ctx, HttpProblem problem, StatusCode statusCode) {
        return "%s | %s".formatted(ErrorHandler.errorMessage(ctx, statusCode), problem.toString());
    }

    public static ProblemDetailsHandler from(Config conf) {
        ProblemDetailsHandler handler = new ProblemDetailsHandler();
        if (conf.hasPath(ROOT_CONFIG_PATH)) {
            Config problemConfig = conf.getConfig(ROOT_CONFIG_PATH);
            if (problemConfig.hasPath(LOG_4XX_ERRORS_KEY) && problemConfig.getBoolean(LOG_4XX_ERRORS_KEY)) {
                handler.log4xxErrors();
            }
            if (problemConfig.hasPath(MUTE_CODES_KEY)) {
                problemConfig.getIntList(MUTE_CODES_KEY).forEach(code -> handler.mute(StatusCode.valueOf(code)));
            }
            if (problemConfig.hasPath(MUTE_TYPES_KEY)) {
                ClassLoader classLoader = ProblemDetailsHandler.class.getClassLoader();
                problemConfig.getStringList(MUTE_TYPES_KEY).forEach(SneakyThrows.throwingConsumer(className -> handler.mute(classLoader.loadClass((String)className))));
            }
        }
        return handler;
    }
}

