/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.validation;

import io.jooby.Context;
import io.jooby.Route;
import io.jooby.SneakyThrows;
import io.jooby.exception.RegistryException;
import io.jooby.validation.ValidationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;

public interface BeanValidator {
    public void validate(Context var1, Object var2) throws RuntimeException;

    public static <T> T apply(Context ctx, T bean) {
        if (bean != null) {
            BeanValidator validator;
            try {
                validator = ctx.require(BeanValidator.class);
            }
            catch (RegistryException cause) {
                throw new RegistryException("Unable to load 'BeanValidator' class. Bean validation usage was detected, but the appropriate dependency is missing. Please ensure that you have added the corresponding validation dependency (e.g., jooby-hibernate-validator, jooby-avaje-validator).");
            }
            if (bean instanceof Iterable) {
                Iterable values2 = (Iterable)bean;
                BeanValidator.validateIterable(validator, ctx, values2);
            } else if (bean.getClass().isArray()) {
                BeanValidator.validateIterable(validator, ctx, List.of((Object[])bean));
            } else if (bean instanceof Map) {
                Map map = (Map)bean;
                BeanValidator.validateIterable(validator, ctx, map.values());
            } else {
                validator.validate(ctx, bean);
            }
        }
        return bean;
    }

    public static Route.Filter validate() {
        return BeanValidator::validate;
    }

    public static Route.Handler validate(Route.Handler next) {
        return ctx -> {
            try {
                if (ctx.getRoute().getAttributes().containsKey(BeanValidator.class.getName())) {
                    return next.apply(ctx);
                }
                return next.apply(new ValidationContext(ctx));
            }
            catch (InvocationTargetException | UndeclaredThrowableException e) {
                throw SneakyThrows.propagate(BeanValidator.getRootCause(e));
            }
        };
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (throwable == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return throwable;
    }

    private static void validateIterable(BeanValidator validator, Context ctx, Iterable<?> beans) {
        for (Object item : beans) {
            validator.validate(ctx, item);
        }
    }
}

