/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.util;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.MessageHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Map<Class<?>, Boolean> getHandlerTypes(Class<? extends MessageHandler> clazz) {
        IdentityHashMap types = new IdentityHashMap(2);
        for (Class<? extends MessageHandler> c = clazz; c != Object.class; c = c.getSuperclass()) {
            ClassUtils.exampleGenericInterfaces(types, c, clazz);
        }
        if (types.isEmpty()) {
            throw JsrWebSocketMessages.MESSAGES.unknownHandlerType(clazz);
        }
        return types;
    }

    private static void exampleGenericInterfaces(Map<Class<?>, Boolean> types, Class<?> c, Class actualClass) {
        for (Type type : c.getGenericInterfaces()) {
            if (type instanceof ParameterizedType) {
                Class rawClass;
                Type messageType;
                ParameterizedType pt = (ParameterizedType)type;
                Type rawType = pt.getRawType();
                if (rawType == MessageHandler.Whole.class) {
                    messageType = pt.getActualTypeArguments()[0];
                    types.put(ClassUtils.resolvePotentialTypeVariable(messageType, c, actualClass), Boolean.FALSE);
                    continue;
                }
                if (rawType == MessageHandler.Partial.class) {
                    messageType = pt.getActualTypeArguments()[0];
                    types.put(ClassUtils.resolvePotentialTypeVariable(messageType, c, actualClass), Boolean.TRUE);
                    continue;
                }
                if (!(rawType instanceof Class) || (rawClass = (Class)rawType).getGenericInterfaces() == null) continue;
                ClassUtils.exampleGenericInterfaces(types, rawClass, actualClass);
                continue;
            }
            if (!(type instanceof Class)) continue;
            ClassUtils.exampleGenericInterfaces(types, (Class)type, actualClass);
        }
    }

    private static Class<?> resolvePotentialTypeVariable(Type messageType, Class<?> c, Class actualClass) {
        if (messageType instanceof Class) {
            return (Class)messageType;
        }
        if (messageType instanceof TypeVariable) {
            Type var = messageType;
            int tvpos = 0;
            ArrayList parents = new ArrayList();
            for (Class i = actualClass; i != c; i = i.getSuperclass()) {
                parents.add(i);
            }
            Collections.reverse(parents);
            for (Class clazz : parents) {
                Type type = clazz.getGenericSuperclass();
                if (!(type instanceof ParameterizedType)) {
                    throw JsrWebSocketMessages.MESSAGES.unknownHandlerType(actualClass);
                }
                ParameterizedType pt = (ParameterizedType)type;
                if (tvpos == -1) {
                    TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
                    for (int j = 0; j < typeParameters.length; ++j) {
                        TypeVariable tp = typeParameters[j];
                        if (!tp.getName().equals(((TypeVariable)var).getName())) continue;
                        tvpos = j;
                        break;
                    }
                }
                if ((var = pt.getActualTypeArguments()[tvpos]) instanceof Class) {
                    return (Class)var;
                }
                tvpos = -1;
            }
            return (Class)var;
        }
        throw JsrWebSocketMessages.MESSAGES.unknownHandlerType(actualClass);
    }

    public static Class<?> getEncoderType(Class<? extends Encoder> clazz) {
        Method[] methods2;
        for (Method m : methods2 = clazz.getMethods()) {
            if (!"encode".equals(m.getName()) || m.isBridge()) continue;
            return m.getParameterTypes()[0];
        }
        throw JsrWebSocketMessages.MESSAGES.unknownEncoderType(clazz);
    }

    public static Class<?> getDecoderType(Class<? extends Decoder> clazz) {
        Method[] methods2;
        for (Method m : methods2 = clazz.getMethods()) {
            if (!"decode".equals(m.getName()) || m.isBridge()) continue;
            return m.getReturnType();
        }
        throw JsrWebSocketMessages.MESSAGES.couldNotDetermineDecoderTypeFor(clazz);
    }
}

