/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.AnnotationTypeCheck;
import org.hibernate.validator.ap.internal.checks.AnnotationTypeMemberCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintChecks;
import org.hibernate.validator.ap.internal.checks.ConstraintValidatorCheck;
import org.hibernate.validator.ap.internal.checks.CrossParameterConstraintCheck;
import org.hibernate.validator.ap.internal.checks.GetterCheck;
import org.hibernate.validator.ap.internal.checks.GroupSequenceProviderCheck;
import org.hibernate.validator.ap.internal.checks.MethodAnnotationCheck;
import org.hibernate.validator.ap.internal.checks.MixDirectAndListAnnotationCheck;
import org.hibernate.validator.ap.internal.checks.MultiValuedChecks;
import org.hibernate.validator.ap.internal.checks.PrimitiveCheck;
import org.hibernate.validator.ap.internal.checks.RetentionPolicyCheck;
import org.hibernate.validator.ap.internal.checks.SingleValuedChecks;
import org.hibernate.validator.ap.internal.checks.StaticCheck;
import org.hibernate.validator.ap.internal.checks.TargetCheck;
import org.hibernate.validator.ap.internal.checks.TypeCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationDefaultMessageCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersDecimalMinMaxCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersDigitsCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersGroupsCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersPatternCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersScriptAssertCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersSizeLengthCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationPayloadUnwrappingCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationUserMessageCheck;
import org.hibernate.validator.ap.internal.checks.annotationparameters.GroupSequenceCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;

public class ConstraintCheckFactory {
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> fieldChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> parameterChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> methodChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> annotationTypeChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> nonAnnotationTypeChecks;
    private final ConstraintHelper constraintHelper;
    private static final SingleValuedChecks NULL_CHECKS = new SingleValuedChecks(new ConstraintCheck[0]);

    public ConstraintCheckFactory(Types typeUtils, Elements elementUtils, ConstraintHelper constraintHelper, AnnotationApiHelper annotationApiHelper, boolean methodConstraintsSupported) {
        this.constraintHelper = constraintHelper;
        this.parameterChecks = CollectionHelper.newHashMap();
        this.parameterChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper)));
        this.parameterChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper)));
        this.parameterChecks.put(ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION, NULL_CHECKS);
        this.parameterChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.fieldChecks = CollectionHelper.newHashMap();
        this.fieldChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new StaticCheck(), new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper), new AnnotationUserMessageCheck(annotationApiHelper), new AnnotationPayloadUnwrappingCheck(annotationApiHelper, typeUtils)));
        this.fieldChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new StaticCheck(), new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper), new AnnotationUserMessageCheck(annotationApiHelper), new AnnotationPayloadUnwrappingCheck(annotationApiHelper, typeUtils)));
        this.fieldChecks.put(ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION, new SingleValuedChecks(new StaticCheck(), new PrimitiveCheck()));
        this.fieldChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.methodChecks = CollectionHelper.newHashMap();
        this.methodChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new GetterCheck(methodConstraintsSupported), new StaticCheck(), new MethodAnnotationCheck(constraintHelper), new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper), new AnnotationUserMessageCheck(annotationApiHelper), new AnnotationPayloadUnwrappingCheck(annotationApiHelper, typeUtils)));
        this.methodChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new GetterCheck(methodConstraintsSupported), new StaticCheck(), new MethodAnnotationCheck(constraintHelper), new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper), new AnnotationUserMessageCheck(annotationApiHelper), new AnnotationPayloadUnwrappingCheck(annotationApiHelper, typeUtils)));
        this.methodChecks.put(ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION, new SingleValuedChecks(new GetterCheck(methodConstraintsSupported), new StaticCheck(), new MethodAnnotationCheck(constraintHelper), new PrimitiveCheck()));
        this.methodChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.annotationTypeChecks = CollectionHelper.newHashMap();
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new AnnotationTypeCheck(constraintHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper), new AnnotationUserMessageCheck(annotationApiHelper), new AnnotationPayloadUnwrappingCheck(annotationApiHelper, typeUtils)));
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new AnnotationTypeCheck(constraintHelper), new MixDirectAndListAnnotationCheck(constraintHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper)));
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_META_ANNOTATION, new SingleValuedChecks(new RetentionPolicyCheck(annotationApiHelper), new TargetCheck(annotationApiHelper), new ConstraintValidatorCheck(constraintHelper, annotationApiHelper), new AnnotationTypeMemberCheck(annotationApiHelper, typeUtils), new CrossParameterConstraintCheck(annotationApiHelper, constraintHelper, typeUtils), new AnnotationDefaultMessageCheck(annotationApiHelper, elementUtils)));
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.nonAnnotationTypeChecks = CollectionHelper.newHashMap();
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper)));
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new TypeCheck(constraintHelper, typeUtils, annotationApiHelper), new AnnotationParametersSizeLengthCheck(annotationApiHelper), new AnnotationParametersPatternCheck(annotationApiHelper), new AnnotationParametersScriptAssertCheck(annotationApiHelper), new AnnotationParametersDigitsCheck(annotationApiHelper), new AnnotationParametersDecimalMinMaxCheck(annotationApiHelper), new AnnotationParametersGroupsCheck(annotationApiHelper)));
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.GROUP_SEQUENCE_ANNOTATION, new SingleValuedChecks(new GroupSequenceCheck(annotationApiHelper, typeUtils, constraintHelper)));
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.GROUP_SEQUENCE_PROVIDER_ANNOTATION, new SingleValuedChecks(new GroupSequenceProviderCheck(annotationApiHelper, typeUtils)));
    }

    public ConstraintChecks getConstraintChecks(Element annotatedElement, AnnotationMirror annotation) {
        ConstraintHelper.AnnotationType annotationType = this.constraintHelper.getAnnotationType(annotation);
        switch (annotatedElement.getKind()) {
            case PARAMETER: {
                return this.parameterChecks.get((Object)annotationType);
            }
            case FIELD: {
                return this.fieldChecks.get((Object)annotationType);
            }
            case METHOD: {
                return this.methodChecks.get((Object)annotationType);
            }
            case ANNOTATION_TYPE: {
                return this.annotationTypeChecks.get((Object)annotationType);
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                return this.nonAnnotationTypeChecks.get((Object)annotationType);
            }
        }
        return NULL_CHECKS;
    }
}

