/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.hibernate.validator.ap.internal.checks.ConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.ConstraintChecks;
import org.hibernate.validator.ap.internal.checks.SingleValuedChecks;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;

public class MultiValuedChecks
implements ConstraintChecks {
    private final ConstraintHelper constraintHelper;
    private final SingleValuedChecks delegate;

    public MultiValuedChecks(ConstraintHelper constraintHelper, ConstraintCheck ... checks) {
        this.constraintHelper = constraintHelper;
        this.delegate = new SingleValuedChecks(checks);
    }

    @Override
    public Set<ConstraintCheckIssue> execute(Element element, AnnotationMirror annotation) {
        HashSet<ConstraintCheckIssue> theValue = CollectionHelper.newHashSet();
        for (AnnotationMirror onePartOfMultiValuedConstraint : this.constraintHelper.getPartsOfMultiValuedConstraint(annotation)) {
            theValue.addAll(this.delegate.execute(element, onePartOfMultiValuedConstraint));
        }
        return theValue;
    }
}

