/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.RetryConfiguration;
import io.fluxcapacitor.common.RetryStatus;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimingUtils.class);

    public static void time(Runnable task, Consumer<Long> callback) {
        TimingUtils.time(() -> {
            task.run();
            return null;
        }, callback);
    }

    public static void time(Runnable task, Consumer<Long> callback, TemporalUnit timeUnit) {
        TimingUtils.time(() -> {
            task.run();
            return null;
        }, callback, timeUnit);
    }

    public static <T> T time(Callable<T> task, Consumer<Long> callback) {
        return TimingUtils.time(task, callback, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public static <T> T time(Callable<T> task, Consumer<Long> callback, TemporalUnit timeUnit) {
        long start = System.nanoTime();
        try {
            T t = task.call();
            return t;
        }
        catch (Exception e) {
            throw new IllegalStateException("Task failed to execute", e);
        }
        finally {
            long elapsedNanos = System.nanoTime() - start;
            callback.accept(elapsedNanos / timeUnit.getDuration().toNanos());
        }
    }

    public static void retryOnFailure(Runnable task, Duration delay) {
        TimingUtils.retryOnFailure(task, delay, (Exception e) -> true);
    }

    public static void retryOnFailure(Runnable task, Duration delay, Predicate<Exception> predicate) {
        TimingUtils.retryOnFailure(() -> {
            task.run();
            return new Object();
        }, delay, predicate);
    }

    public static <T> T retryOnFailure(Callable<T> task, Duration delay) {
        return TimingUtils.retryOnFailure(task, delay, (Exception e) -> true);
    }

    public static <T> T retryOnFailure(Callable<T> task, Duration delay, Predicate<Exception> errorTest) {
        return TimingUtils.retryOnFailure(task, RetryConfiguration.builder().delay(delay).errorTest(errorTest).build());
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T retryOnFailure(Callable<T> task, RetryConfiguration configuration) {
        retryStatus = null;
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                result = task.call();
                if (result instanceof CompletableFuture) {
                    ((CompletableFuture)result).get();
                }
                if (retryStatus != null) {
                    configuration.getSuccessLogger().accept(retryStatus);
                }
                return result;
            }
            catch (Exception e) {
                v0 = retryStatus = retryStatus == null ? RetryStatus.builder().retryConfiguration(configuration).exception(e).task(task).build() : retryStatus.afterRetry(e);
                if (!configuration.getErrorTest().test(e)) {
                    if (configuration.isThrowOnFailingErrorTest()) {
                        throw retryStatus.getException();
                    }
                    return null;
                }
                configuration.getExceptionLogger().accept(retryStatus);
                if (configuration.getMaxRetries() >= 0 && retryStatus.getNumberOfTimesRetried() >= configuration.getMaxRetries()) break;
                try {
                    Thread.sleep(configuration.getDelay().toMillis());
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    TimingUtils.log.info("Thread interrupted while retrying task {}", (Object)task, (Object)e1);
                    break;
                }
            }
            ** while (true)
            catch (Error e) {
                TimingUtils.log.error("Task {} failed with error. Will not retry.", (Object)task, (Object)e);
                throw e;
            }
            break;
        }
        throw retryStatus.getException();
    }

    public static boolean isMissedDeadline(long deadline) {
        return System.currentTimeMillis() > deadline;
    }
}

