/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api;

import io.fluxcapacitor.common.ThrowingFunction;
import io.fluxcapacitor.common.api.SerializedObject;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;

public final class Data<T>
implements SerializedObject<T, Data<T>> {
    public static final String JSON_FORMAT = "application/json";
    public static final String DOCUMENT_FORMAT = "document";
    private final Supplier<T> value;
    private final String type;
    private final int revision;
    private final String format;

    @ConstructorProperties(value={"value", "type", "revision", "format"})
    public Data(T value, String type, int revision, String format) {
        this(() -> value, type, revision, format);
    }

    public Data(T value, String type, int revision) {
        this(value, type, revision, null);
    }

    public Data(Supplier<T> value, String type, int revision, String format) {
        this.value = value;
        this.type = type;
        this.revision = revision;
        this.format = format;
    }

    public T getValue() {
        return this.value.get();
    }

    public String getFormat() {
        return this.format == null || "json".equals(this.format) ? JSON_FORMAT : this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return this.revision == data.revision && Objects.deepEquals(this.getValue(), data.getValue()) && Objects.equals(this.type, data.type) && Objects.equals(this.getFormat(), data.getFormat());
    }

    public int hashCode() {
        return Objects.hash(this.getValue(), this.type, this.revision, this.format);
    }

    @Override
    public Data<T> data() {
        return this;
    }

    @Override
    public Data<T> withData(Data<T> data) {
        return data;
    }

    public <M> Data<M> map(ThrowingFunction<T, M> mapper) {
        return new Data<M>(mapper.apply(this.getValue()), this.type, this.revision, this.format);
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public int getRevision() {
        return this.revision;
    }

    @Generated
    public String toString() {
        return "Data(type=" + this.getType() + ", revision=" + this.getRevision() + ", format=" + this.getFormat() + ")";
    }

    @Generated
    public Data<T> withType(String type) {
        return this.type == type ? this : new Data<T>(this.value, type, this.revision, this.format);
    }

    @Generated
    public Data<T> withRevision(int revision) {
        return this.revision == revision ? this : new Data<T>(this.value, this.type, revision, this.format);
    }

    @Generated
    public Data<T> withFormat(String format) {
        return this.format == format ? this : new Data<T>(this.value, this.type, this.revision, format);
    }
}

