/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import io.fluxcapacitor.common.api.search.Group;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class DocumentStats {
    private final Map<String, FieldStats> fieldStats;
    private final Group group;

    public static List<DocumentStats> compute(Stream<Document> documents, List<String> fields2, List<String> groupBy) {
        List<String> finalFields = fields2.isEmpty() ? List.of("") : fields2;
        Map<List, List<Document>> groups2 = documents.collect(Collectors.groupingBy(d -> groupBy.stream().map(g -> d.getEntryAtPath((String)g).map(Document.Entry::getValue).orElse(null)).collect(Collectors.toList())));
        Stream<DocumentStats> statsStream = groups2.entrySet().stream().map(e -> new DocumentStats(finalFields.stream().collect(Collectors.toMap(Function.identity(), f -> new FieldStats((List)e.getValue(), (String)f), (a, b) -> b)), DocumentStats.asGroup(groupBy, (List)e.getKey())));
        Comparator comparator = groupBy.stream().map(g -> Comparator.nullsLast(Comparator.comparing(d -> d.getGroup().get((String)g), Comparator.nullsLast(Comparator.naturalOrder())))).reduce(Comparator::thenComparing).orElse((a, b) -> 0);
        return statsStream.sorted(comparator).collect(Collectors.toList());
    }

    private static Group asGroup(List<String> groupBy, List<String> values2) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < groupBy.size(); ++i) {
            result.put(groupBy.get(i), values2.get(i));
        }
        return new Group(result);
    }

    @ConstructorProperties(value={"fieldStats", "group"})
    @Generated
    public DocumentStats(Map<String, FieldStats> fieldStats, Group group) {
        this.fieldStats = fieldStats;
        this.group = group;
    }

    @Generated
    public Map<String, FieldStats> getFieldStats() {
        return this.fieldStats;
    }

    @Generated
    public Group getGroup() {
        return this.group;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentStats)) {
            return false;
        }
        DocumentStats other = (DocumentStats)o;
        Map<String, FieldStats> this$fieldStats = this.getFieldStats();
        Map<String, FieldStats> other$fieldStats = other.getFieldStats();
        if (this$fieldStats == null ? other$fieldStats != null : !((Object)this$fieldStats).equals(other$fieldStats)) {
            return false;
        }
        Group this$group = this.getGroup();
        Group other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !((Object)this$group).equals(other$group));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, FieldStats> $fieldStats = this.getFieldStats();
        result = result * 59 + ($fieldStats == null ? 43 : ((Object)$fieldStats).hashCode());
        Group $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentStats(fieldStats=" + String.valueOf(this.getFieldStats()) + ", group=" + String.valueOf(this.getGroup()) + ")";
    }

    public static final class FieldStats {
        private final long count;
        private final BigDecimal min;
        private final BigDecimal max;
        private final BigDecimal sum;
        private final BigDecimal average;

        protected FieldStats(List<Document> documents, String path) {
            List values2;
            this.count = documents.size();
            List<Object> list = values2 = path.isBlank() ? List.of() : documents.stream().flatMap(d -> d.getEntryAtPath(path).stream()).filter(e -> e.getType() == Document.EntryType.NUMERIC).map(e -> new BigDecimal(e.getValue())).sorted().toList();
            if (values2.isEmpty()) {
                this.average = null;
                this.sum = null;
                this.max = null;
                this.min = null;
            } else {
                this.min = (BigDecimal)values2.get(0);
                this.max = (BigDecimal)values2.get(values2.size() - 1);
                this.sum = values2.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                this.average = this.sum.divide(new BigDecimal(values2.size()), new MathContext(10, RoundingMode.HALF_UP)).stripTrailingZeros();
            }
        }

        @Generated
        public long getCount() {
            return this.count;
        }

        @Generated
        public BigDecimal getMin() {
            return this.min;
        }

        @Generated
        public BigDecimal getMax() {
            return this.max;
        }

        @Generated
        public BigDecimal getSum() {
            return this.sum;
        }

        @Generated
        public BigDecimal getAverage() {
            return this.average;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldStats)) {
                return false;
            }
            FieldStats other = (FieldStats)o;
            if (this.getCount() != other.getCount()) {
                return false;
            }
            BigDecimal this$min = this.getMin();
            BigDecimal other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            BigDecimal this$max = this.getMax();
            BigDecimal other$max = other.getMax();
            if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                return false;
            }
            BigDecimal this$sum = this.getSum();
            BigDecimal other$sum = other.getSum();
            if (this$sum == null ? other$sum != null : !((Object)this$sum).equals(other$sum)) {
                return false;
            }
            BigDecimal this$average = this.getAverage();
            BigDecimal other$average = other.getAverage();
            return !(this$average == null ? other$average != null : !((Object)this$average).equals(other$average));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $count = this.getCount();
            result = result * 59 + (int)($count >>> 32 ^ $count);
            BigDecimal $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            BigDecimal $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            BigDecimal $sum = this.getSum();
            result = result * 59 + ($sum == null ? 43 : ((Object)$sum).hashCode());
            BigDecimal $average = this.getAverage();
            result = result * 59 + ($average == null ? 43 : ((Object)$average).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DocumentStats.FieldStats(count=" + this.getCount() + ", min=" + String.valueOf(this.getMin()) + ", max=" + String.valueOf(this.getMax()) + ", sum=" + String.valueOf(this.getSum()) + ", average=" + String.valueOf(this.getAverage()) + ")";
        }

        @ConstructorProperties(value={"count", "min", "max", "sum", "average"})
        @Generated
        public FieldStats(long count, BigDecimal min, BigDecimal max, BigDecimal sum, BigDecimal average) {
            this.count = count;
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.average = average;
        }
    }
}

