/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class IndexDocuments
extends Command {
    private final List<SerializedDocument> documents;
    private final boolean ifNotExists;
    private final Guarantee guarantee;

    @JsonIgnore
    public int getSize() {
        return this.documents.size();
    }

    public String toString() {
        return "IndexDocuments of length " + this.documents.size();
    }

    @Override
    public Metric toMetric() {
        return new Metric(this.getSize(), this.ifNotExists, this.guarantee, this.documents.stream().map(SerializedDocument::getCollection).collect(Collectors.toSet()), this.documents.stream().map(SerializedDocument::getId).toList());
    }

    @Override
    public String routingKey() {
        return this.documents.getFirst().getId();
    }

    @ConstructorProperties(value={"documents", "ifNotExists", "guarantee"})
    @Generated
    public IndexDocuments(List<SerializedDocument> documents, boolean ifNotExists, Guarantee guarantee) {
        this.documents = documents;
        this.ifNotExists = ifNotExists;
        this.guarantee = guarantee;
    }

    @Generated
    public List<SerializedDocument> getDocuments() {
        return this.documents;
    }

    @Generated
    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Generated
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDocuments)) {
            return false;
        }
        IndexDocuments other = (IndexDocuments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIfNotExists() != other.isIfNotExists()) {
            return false;
        }
        List<SerializedDocument> this$documents = this.getDocuments();
        List<SerializedDocument> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexDocuments;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIfNotExists() ? 79 : 97);
        List<SerializedDocument> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result;
    }

    public static final class Metric {
        private final int size;
        private final boolean ifNotExists;
        private final Guarantee guarantee;
        private final Set<String> collections;
        private final List<String> ids;

        @ConstructorProperties(value={"size", "ifNotExists", "guarantee", "collections", "ids"})
        @Generated
        public Metric(int size, boolean ifNotExists, Guarantee guarantee, Set<String> collections, List<String> ids) {
            this.size = size;
            this.ifNotExists = ifNotExists;
            this.guarantee = guarantee;
            this.collections = collections;
            this.ids = ids;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public boolean isIfNotExists() {
            return this.ifNotExists;
        }

        @Generated
        public Guarantee getGuarantee() {
            return this.guarantee;
        }

        @Generated
        public Set<String> getCollections() {
            return this.collections;
        }

        @Generated
        public List<String> getIds() {
            return this.ids;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.isIfNotExists() != other.isIfNotExists()) {
                return false;
            }
            Guarantee this$guarantee = this.getGuarantee();
            Guarantee other$guarantee = other.getGuarantee();
            if (this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee)) {
                return false;
            }
            Set<String> this$collections = this.getCollections();
            Set<String> other$collections = other.getCollections();
            if (this$collections == null ? other$collections != null : !((Object)this$collections).equals(other$collections)) {
                return false;
            }
            List<String> this$ids = this.getIds();
            List<String> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + (this.isIfNotExists() ? 79 : 97);
            Guarantee $guarantee = this.getGuarantee();
            result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
            Set<String> $collections = this.getCollections();
            result = result * 59 + ($collections == null ? 43 : ((Object)$collections).hashCode());
            List<String> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IndexDocuments.Metric(size=" + this.getSize() + ", ifNotExists=" + this.isIfNotExists() + ", guarantee=" + String.valueOf((Object)this.getGuarantee()) + ", collections=" + String.valueOf(this.getCollections()) + ", ids=" + String.valueOf(this.getIds()) + ")";
        }
    }
}

