/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.Position;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public final class MessageBatch {
    private final int[] segment;
    private final List<SerializedMessage> messages;
    private final Long lastIndex;
    private final Position position;

    @JsonIgnore
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @JsonIgnore
    public int getSize() {
        return this.messages.size();
    }

    public String toString() {
        return "MessageBatch{segment=" + Arrays.toString(this.segment) + ", lastIndex=" + this.lastIndex + ", message count=" + this.messages.size() + "}";
    }

    @JsonIgnore
    public Metric toMetric() {
        return new Metric(this.segment, this.getSize(), this.lastIndex, this.position);
    }

    @ConstructorProperties(value={"segment", "messages", "lastIndex", "position"})
    @Generated
    public MessageBatch(int[] segment, List<SerializedMessage> messages, Long lastIndex, Position position) {
        this.segment = segment;
        this.messages = messages;
        this.lastIndex = lastIndex;
        this.position = position;
    }

    @Generated
    public int[] getSegment() {
        return this.segment;
    }

    @Generated
    public List<SerializedMessage> getMessages() {
        return this.messages;
    }

    @Generated
    public Long getLastIndex() {
        return this.lastIndex;
    }

    @Generated
    public Position getPosition() {
        return this.position;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageBatch)) {
            return false;
        }
        MessageBatch other = (MessageBatch)o;
        Long this$lastIndex = this.getLastIndex();
        Long other$lastIndex = other.getLastIndex();
        if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
            return false;
        }
        if (!Arrays.equals(this.getSegment(), other.getSegment())) {
            return false;
        }
        List<SerializedMessage> this$messages = this.getMessages();
        List<SerializedMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lastIndex = this.getLastIndex();
        result = result * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSegment());
        List<SerializedMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public static final class Metric {
        private final int[] segment;
        private final int size;
        private final Long lastIndex;
        private final Position position;

        @ConstructorProperties(value={"segment", "size", "lastIndex", "position"})
        @Generated
        public Metric(int[] segment, int size, Long lastIndex, Position position) {
            this.segment = segment;
            this.size = size;
            this.lastIndex = lastIndex;
            this.position = position;
        }

        @Generated
        public int[] getSegment() {
            return this.segment;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public Long getLastIndex() {
            return this.lastIndex;
        }

        @Generated
        public Position getPosition() {
            return this.position;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Long this$lastIndex = this.getLastIndex();
            Long other$lastIndex = other.getLastIndex();
            if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
                return false;
            }
            if (!Arrays.equals(this.getSegment(), other.getSegment())) {
                return false;
            }
            Position this$position = this.getPosition();
            Position other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            Long $lastIndex = this.getLastIndex();
            result = result * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
            result = result * 59 + Arrays.hashCode(this.getSegment());
            Position $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessageBatch.Metric(segment=" + Arrays.toString(this.getSegment()) + ", size=" + this.getSize() + ", lastIndex=" + this.getLastIndex() + ", position=" + String.valueOf(this.getPosition()) + ")";
        }
    }
}

