/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.application;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.application.PropertySource;
import io.fluxcapacitor.common.encryption.DefaultEncryption;
import io.fluxcapacitor.common.encryption.Encryption;
import io.fluxcapacitor.common.encryption.NoOpEncryption;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptingPropertySource
implements PropertySource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecryptingPropertySource.class);
    private final PropertySource delegate;
    private final Encryption encryption;
    private final Function<String, String> decryptionCache = ObjectUtils.memoize(s -> this.getEncryption().decrypt((String)s));

    public DecryptingPropertySource(PropertySource delegate) {
        this(delegate, (String)Optional.ofNullable(System.getenv("ENCRYPTION_KEY")).or(() -> Optional.ofNullable(System.getenv("encryption_key"))).or(() -> Optional.ofNullable(System.getProperty("ENCRYPTION_KEY"))).or(() -> Optional.ofNullable(System.getProperty("encryption_key"))).orElse(null));
    }

    public DecryptingPropertySource(PropertySource delegate, String encryptionKey) {
        this(delegate, Optional.ofNullable(encryptionKey).map(encodedKey -> {
            try {
                return DefaultEncryption.fromEncryptionKey(encodedKey);
            }
            catch (Exception e) {
                log.error("Could not construct DefaultEncryption from environment variable `ENCRYPTION_KEY`");
                return null;
            }
        }).orElseGet(() -> new DefaultEncryption(NoOpEncryption.INSTANCE)));
    }

    @Override
    public String get(String name) {
        String value = this.delegate.get(name);
        return value == null ? null : this.decryptionCache.apply(value);
    }

    @ConstructorProperties(value={"delegate", "encryption"})
    @Generated
    public DecryptingPropertySource(PropertySource delegate, Encryption encryption) {
        this.delegate = delegate;
        this.encryption = encryption;
    }

    @Generated
    public Encryption getEncryption() {
        return this.encryption;
    }
}

