/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.encryption;

import io.fluxcapacitor.common.encryption.Encryption;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;

public class ChaCha20Poly1305Encryption
implements Encryption {
    public static final String ALGORITHM = "ChaCha20";
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final String TRANSFORMATION = "ChaCha20-Poly1305/None/NoPadding";
    private static final int NONCE_LENGTH = 12;
    private static final int KEY_SIZE = 256;
    private static final int TAG_LENGTH = 16;
    private final SecretKey encryptionKey;

    public ChaCha20Poly1305Encryption() {
        this(ChaCha20Poly1305Encryption.generateEncryptionKey());
    }

    public ChaCha20Poly1305Encryption(String encryptionKey) {
        this(new SecretKeySpec(ChaCha20Poly1305Encryption.decode(encryptionKey), ALGORITHM));
    }

    @Override
    public String encrypt(String value) {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(ChaCha20Poly1305Encryption.nextNonce());
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)this.encryptionKey, ivParameterSpec);
        byte[] ciphertextWithTag = cipher.doFinal(value.getBytes(StandardCharsets.UTF_8));
        byte[] ciphertext = new byte[ciphertextWithTag.length - 16];
        byte[] tag = new byte[16];
        System.arraycopy(ciphertextWithTag, 0, ciphertext, 0, ciphertextWithTag.length - 16);
        System.arraycopy(ciphertextWithTag, ciphertextWithTag.length - 16, tag, 0, 16);
        return ChaCha20Poly1305Encryption.encode(ivParameterSpec.getIV()) + ":" + ChaCha20Poly1305Encryption.encode(ciphertext) + ":" + ChaCha20Poly1305Encryption.encode(tag);
    }

    @Override
    public String decrypt(String value) {
        String[] parts = value.split(":", 0);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, (Key)this.encryptionKey, new IvParameterSpec(ChaCha20Poly1305Encryption.decode(parts[0])));
        return new String(cipher.doFinal(ChaCha20Poly1305Encryption.concatenate(ChaCha20Poly1305Encryption.decode(parts[1]), ChaCha20Poly1305Encryption.decode(parts[2]))));
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getEncryptionKey() {
        return ChaCha20Poly1305Encryption.encode(this.encryptionKey.getEncoded());
    }

    @Override
    public boolean isEncrypted(String value) {
        throw new UnsupportedOperationException();
    }

    private static SecretKey generateEncryptionKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    private static byte[] nextNonce() {
        byte[] newNonce = new byte[12];
        secureRandom.nextBytes(newNonce);
        return newNonce;
    }

    private static String encode(byte[] input) {
        return Base64.getEncoder().encodeToString(input);
    }

    private static byte[] decode(String input) {
        return Base64.getDecoder().decode(input);
    }

    private static byte[] concatenate(byte[] a, byte[] b) {
        return ByteBuffer.allocate(a.length + b.length).put(a).put(b).array();
    }

    @ConstructorProperties(value={"encryptionKey"})
    @Generated
    private ChaCha20Poly1305Encryption(SecretKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }
}

