/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;

public interface HandlerInvoker {
    public static Optional<HandlerInvoker> join(final List<? extends HandlerInvoker> invokers) {
        if (invokers.isEmpty()) {
            return Optional.empty();
        }
        if (invokers.size() == 1) {
            return Optional.of(invokers.getFirst());
        }
        return Optional.of(new DelegatingHandlerInvoker(invokers.getFirst()){

            @Override
            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                Object result = this.delegate.invoke();
                for (int i = 1; i < invokers.size(); ++i) {
                    result = combiner.apply(result, ((HandlerInvoker)invokers.get(i)).invoke());
                }
                return result;
            }
        });
    }

    public Class<?> getTargetClass();

    public Executable getMethod();

    public <A extends Annotation> A getMethodAnnotation();

    public boolean expectResult();

    public boolean isPassive();

    default public Object invoke() {
        return this.invoke((first, second) -> {
            ArrayList<Object> combination;
            ArrayList<Object> arrayList = first instanceof ArrayList ? (ArrayList<Object>)first : (combination = first instanceof Collection ? new ArrayList((Collection)first) : new ArrayList<Object>(Collections.singletonList(first)));
            if (second instanceof Collection) {
                combination.addAll((Collection)second);
            } else {
                combination.add(second);
            }
            return combination;
        });
    }

    public Object invoke(BiFunction<Object, Object, Object> var1);

    public static abstract class DelegatingHandlerInvoker
    implements HandlerInvoker {
        protected final HandlerInvoker delegate;

        @Override
        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }

        @Override
        public Executable getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation() {
            return this.delegate.getMethodAnnotation();
        }

        @Override
        public boolean expectResult() {
            return this.delegate.expectResult();
        }

        @Override
        public boolean isPassive() {
            return this.delegate.isPassive();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        public DelegatingHandlerInvoker(HandlerInvoker delegate) {
            this.delegate = delegate;
        }
    }
}

